import viz
viz.go()

balloon = viz.add('balloon.ive')

balloon.setScale([0.1,0.1,0.1])
balloon.setPosition([0,1.8,4])
balloon.color(viz.BLUE)

ground = viz.add('tut_ground.wrl')

inflate_sound = viz.addAudio('blowballoon.wav')

import vizact

#define my actions
grow = vizact.size([2,2,2],3,viz.TIME)
play_sound = vizact.call(inflate_sound.play)
transparent = vizact.fadeTo(0.6,time=3)
inflate = vizact.parallel([grow,play_sound,transparent])
float_away = vizact.move([0,1,0],5)

#balloon.addAction(grow)
#balloon.addAction(play_sound)
#balloon.addAction(transparent)

#add my actions
balloon.addAction(inflate)
balloon.addAction(float_away)

import random
balloons = []
for i in range(-5,6):
	for j in range(1,10):
		balloon = balloon.copy()
		R = random.random()
		G = random.random()
		B = random.random()
		balloon.color([R,G,B])
		balloon.specular(viz.WHITE)
		balloon.shininess(128)
		balloon.setPosition(i*0.8,0.1,j*0.8)
		balloons.append(balloon)

wait = vizact.randfloat(0.5,7)
random_wait = vizact.waittime(wait)

def inflateBalloons():
	for balloon in balloons:
		balloon.addAction(inflate)
		balloon.addAction(random_wait)
		balloon.addAction(float_away)
		
vizact.onkeydown(' ',inflateBalloons)		

	
		