import viz
import viztracker
viztracker.go()

viz.add('tut_ground.wrl')
viz.clearcolor(viz.SKYBLUE)

viz.MainView.getHeadLight().disable()
light = viz.addLight()
light.position(0, 1, 0, 0)
light.intensity(2)

#import vizcam
#viz.cam.setHandler(vizcam.KeyboardCamera())

avatarFiles = ['vcc_female.cfg', 'vcc_male.cfg']
avatarModels = []
for avatarFile in avatarFiles:	
	avatar = viz.add(avatarFile)
	avatar.setPosition([0, 0, 3])
	avatar.setEuler([180, 0, 0])
	avatar.state(1)
	avatar.ambient([2.5]*3)
	#text setup
	avatar.frontName = viz.addText('front', \
	parent=avatar, \
	pos=[0, 1.4, .3], \
	euler=[180, 0, 0], \
	scale=[.02]*3)
	avatar.backName = viz.addText('back', \
	parent=avatar, \
	pos=[0, 1.4, -.3], \
	euler=[0, 0, 0], \
	scale=[.02]*3)
	#################
	avatarModels.append(avatar)

import viztask
def doExperiment():
	print 'start'	
	
	yield doTrial(1, 'jane', 'doe')
	yield doTrial(0, 'john', 'doe')
	yield doTrial(1, 'Ms.', 'Daisy')
	print 'end'
	viz.quit()

subjectID = viz.input('Enter subject id...')
viztask.schedule(doExperiment())

#startTimeTick = 0
def doTrial(avatarNumber, frontName, lastName):
	global startTimeTick	
	for avatar in avatarModels:
		avatar.visible(viz.OFF)
	currentAvatar = avatarModels[avatarNumber]
	currentAvatar.visible(viz.ON)
	currentAvatar.frontName.message(frontName)
	currentAvatar.backName.message(lastName)
	viz.playsound('BUZZER.WAV')	
	dataFile.write('New trial, AvatarNumber:' + str(avatarNumber) + '\n')
	startTimeTick = viz.tick()
	yield viztask.waitKeyDown(' ')


dataFile = open('dataDirectory/' + str(subjectID) + '.txt', 'a')
dataFile.write('Seconds, distance \n')

import vizmat
avatarPosition = avatarModels[0].getPosition()
def writeDistanceTask():
	while True:
		userPos = viz.MainView.getPosition()
		distance = vizmat.Distance(userPos, avatarPosition)
		secondsTrialHasBeenGoing = viz.tick() - startTimeTick
		dataFile.write(str(secondsTrialHasBeenGoing) + ' ' + str(distance) + '\n')
		yield None
		
viztask.schedule( writeDistanceTask() )


