import viz
viz.go()

court = viz.add('court.ive')

coordinates = [[-1,0,4],[0,0,4],[1,0,4]]
my_avatars = []

for pos in coordinates:
	a = viz.add('vcc_male.cfg')
	a.setPosition(pos)
	a.setEuler(180,0,0)
	my_avatars.append(a)
	
my_avatars[0].state(5)
my_avatars[1].state(8)
my_avatars[2].state(10)

import vizact

def resetView():
	viz.MainView.setPosition([0,1.82,0])
	viz.MainView.setEuler([0,0,0])
	
vizact.onkeydown('r',resetView)

def hideAvatars():
	for avatar in my_avatars:
		avatar.visible(viz.TOGGLE)
		
vizact.onkeydown('h',hideAvatars)


walk = vizact.walkTo([0,0,10])
def avatarWalk():
	my_avatars[1].addAction(walk)
	
vizact.ontimer2(5,0,avatarWalk)	

def changeState():
	for avatar in my_avatars:
		avatar.state(5)
		
vizact.ontimer2(15,0,changeState)	


my_text = viz.addText('message',viz.SCREEN)
my_text.color(viz.BLUE)
my_text.setPosition(0.1,0.9)

def showPosition():
	pos = viz.MainView.getPosition()
	posx = round(pos[0],2)
	posy = round(pos[1],2)
	posz = round(pos[2],2)
	pos_string = str(posx) + ' ' + str(posy)+ ' ' + str(posz)
	my_text.message(str(pos_string))
	
vizact.ontimer(0,showPosition)	


import vizcam
viz.cam.setHandler(vizcam.FlyNavigate())