import viz
import viztask
import vizmat
viz.go()

#avatarRoot = viz.addGroup()
avatarRoot = viz.add('marker.wrl')
cameraLookAtNode = viz.addGroup(parent=avatarRoot, pos=[0, 1.5, 0])
avatar = viz.add('vcc_male.cfg', parent=avatarRoot)
viz.add('tut_ground.wrl')

def moveAvatar():
	while True:
		#get user input
		newPos = vizmat.Vector()
		newPos.set([0,0,0])
		if viz.iskeydown('w'):
			#walk forward
			newPos = newPos + [0, 0, 1]
		if viz.iskeydown('s'):
			newPos = newPos + [0, 0, -1]
		if viz.iskeydown('a'):
			newPos = newPos + [-1, 0, 0]
		if viz.iskeydown('d'):
			newPos = newPos + [1, 0, 0]		
		isJumping = False
		isAttacking = False
		if viz.iskeydown(' '):
			#jump
			isJumping = True
		elif viz.iskeydown('v'):
			isAttacking = True
		
		if isAttacking:			
			avatar.state(6)
			yield viztask.waitTime( 1.5 )
		if newPos.length() > 0 or isJumping:
			if newPos.length() == 0:
				#jumping but no direction key, use current heading
				t = vizmat.Transform()
				t.setTrans([0, 0, 1.8])
				t.postEuler(avatar.getEuler()[0],0,0)
				newPos = vizmat.Vector( t.getTrans() )
			newYaw = vizmat.AngleToPoint(0, 0, newPos[0], newPos[2])
			avatar.setEuler(newYaw, 0, 0)
			if not isJumping:
				#just walking				
				cameraEuler = viz.MainView.getEuler()
				avatarRoot.setEuler(cameraEuler[0], 0, 0)
				newPos = newPos * viz.getFrameElapsed()
				avatarRoot.setPosition(newPos, viz.REL_LOCAL)
				avatar.state(2)
			else:
				#jumping
				avatar.state(7)
				yield viztask.waitTime( avatar.getDuration(7)+.01 )
				#compute jump direction
				newJumpPos = vizmat.Transform()
				newJumpPos.setTrans([0, 0, 1.8])
				newJumpPos.postEuler(avatar.getEuler(viz.ABS_GLOBAL)[0], 0, 0)
				avatarRoot.setPosition(newJumpPos.getTrans(), viz.REL_GLOBAL)
		
		
		
		if not (viz.iskeydown(' ') or viz.iskeydown('w') or viz.iskeydown('s') or viz.iskeydown('a') or viz.iskeydown('d') ):
			avatar.state(1)
			
		yield None
		
viztask.schedule(moveAvatar())

import vizcam
camera = vizcam.PivotNavigate()
camera.setDistance(5)

def moveCamera():
	while True:
		lookAtPos = avatar.getBone('Bip01 Pelvis').getPosition(viz.ABS_GLOBAL)
		lookAtPos[1] = lookAtPos[1] + .5
		camera.setCenter(lookAtPos)
		camera.updateCenter()
		yield None	

viztask.schedule(moveCamera())


