import viz
viz.go()

import vizinfo
info = vizinfo.add("Pause and resume path 1 using 'p/r' keys.\nAnimate path 2 between 2 path times by pressing the spacebar.\nUse the slider to manually set the time of path 2")
info.translate(0.85,1)

#Place animating balls in front of user
model = viz.add('anim_balls.osg')
model.setEuler(-90,0,0)
model.setPosition(0,-5,15)

#Import module for controlling animation paths
import animpath

#Get handle to animation path of 'GeoSphere01' subnode
path1 = animpath.Path(model,'GeoSphere01')

#Get handle to animation path of 'GeoSphere02' subnode
path2 = animpath.Path(model,'GeoSphere02')

#Set looping mode for path 1 to SWING
#This causes path to play backwards when it reaches the end
path1.setLoopMode(animpath.SWING)

#Pause path 2
path2.setPause(True)

#Disable lopoing on path
path2.setLoopMode(animpath.NO_LOOPING)

#Create slider to manually set time of path 2
slider = viz.addSlider(pos=(0.8,0.1,0))
def SetTime(pos):
	path2.setTime( vizmat.Interpolate(path2.getFirstTime(),path2.getLastTime(),pos) )
vizact.onslider(slider,SetTime)

#Disable mouse navigation
viz.mouse(0)

#Pause/resume path 1 when 'p/r' keys are pressed
vizact.onkeydown('p',path1.setPause,True)
vizact.onkeydown('r',path1.setPause,False)

#Add animation action on spacebar
vizact.onkeydown(' ',path2.runAction,vizact.choice([animpath.animateTo(2),animpath.animateTo(0)]))
