import viz
import vizact

_mod = viz.addModifier('animpath.dlm')

#Loop modes
SWING		= 0
LOOP		= 1
NO_LOOPING	= 2

class Path(viz.VizActor):
	"""Class for controlling an OSG animation path"""
	
	def __init__(self,node,name=''):
		viz.VizActor.__init__(self)
		self.node = node
		self.name = name
		
	def setTime(self,seconds):
		"""Set time of animation path, in seconds"""
		self.node.modify(_mod,5,self.name,seconds)
		
	def getTime(self):
		"""Get current time of animation"""
		self.node.modify(_mod,6,self.name)
		return _mod.get()[0]
		
	def getPeriod(self):
		"""Get period of animation path, in seconds"""
		self.node.modify(_mod,2,self.name)
		return _mod.get()[0]
		
	def getFirstTime(self):
		"""Get time of first control point"""
		self.node.modify(_mod,3,self.name)
		return _mod.get()[0]
		
	def getLastTime(self):
		"""Get time of last control point"""
		self.node.modify(_mod,4,self.name)
		return _mod.get()[0]
		
	def setLoopMode(self,mode):
		"""Set loop mode of animation path"""
		self.node.modify(_mod,0,self.name,mode)
		
	def getLoopMode(self):
		"""Get loop mode of animation path"""
		self.node.modify(_mod,1,self.name)
		return int(_mod.get()[0])
		
	def setPause(self,mode):
		"""Set whether the animation path should be paused"""
		self.node.modify(_mod,7,self.name,mode)
		
	def getPause(self):
		"""Get whether the animation path is paused"""
		self.node.modify(_mod,8,self.name)
		return bool(_mod.get()[0])
		
	def reset(self):
		"""Reset animation path"""
		self.node.modify(_mod,9,self.name)

def animateTo(seconds,speed=1.0,time=None):
	"""Returns an action that will animate the path to the specified time"""
	bla = viz.ActionData()
	bla.data = [seconds,speed,time]
	bla.actionclass = _AnimatePathAction
	return bla

class _AnimatePathAction(viz.ActionClass):

	def begin(self,object):
		data = vizact._paramlist_(self._actiondata_.data,object)
	
		beginTime = object.getTime()
		self.endTime = data[0]
		self.elapsed = 0.0
		self.duration = 0.0
		
		speed = data[1]
		time = data[2]
		
		if time is not None:
			self.duration = time
		elif speed is not None:
			self.duration = abs(self.endTime-beginTime) / speed

		if self.duration <= 0.0:
			object.setTime(self.endTime)
			self.end(object)
			return

		interpolator = vizact.VizLinearInterpolator()
		interpolator.init(beginTime,self.endTime)
		self.interpolate = interpolator.interpolate
		
	def update(self,elapsed,object):

		self.elapsed += elapsed
		p = self.elapsed / self.duration
		if p >= 1.0:
			self._overtime_ = self.elapsed - self.duration
			object.setTime(self.endTime)
			self.end(object)
			return
	
		object.setTime(self.interpolate(p))