'''
Moves the view according to user input
'''	

import viz
import vizact
import vizmat
import viztask
import math

X_POS = 0
Y_POS = 1
Z_POS = 2



class UserAvatar(viz.EventClass):
    THROTTLE_SPEED = 4
    HYPER_THROTTLE_SPEED = 30
    TURN_SPEED = .1    
    def __init__(self):
        viz.EventClass.__init__(self)        
        
        self.feet = viz.addGroup(pos=[0,0,0])        
        self.physicShape = self.feet.collideCapsule(euler=[0,90,0], radius=.36, length=1, friction=.00000001, hardness=.0000001, bounce=0)
        self.velMotor = self.feet.addVelocity(velocity=[0,0,0], maxForce=100, gravity=False)
        
        self.head = viz.addGroup()
        
        self.onTopOfFeet=self.feet.add('ball.wrl')
        self.onTopOfFeet.setPosition(0,1.82,0)
        self.onTopOfFeet.visible(viz.OFF)
        
        
        
        #self.Position = self.feet.getPosition()        
        self.BodyRotation = 0
        self.OldBodyRotation = self.BodyRotation
        self.OldPosition = list(self.feet.getPosition())
        
        self.HeadControlOn = True
        self.RotationOn = True
        self.MoveOn = True
        
        self.mouseDx = 0
        self.mouseDy = 0
        self.callback(viz.MOUSE_MOVE_EVENT, self.onMouseMove)
        vizact.onupdate(viz.PRIORITY_PHYSICS-1, self.updatePrePhysics)
        vizact.onupdate(viz.PRIORITY_PHYSICS+1, self.updatePostPhysics)
        
    
    
    def GetRotationRequest(self):
        toReturn = self.mouseDx *self.TURN_SPEED
        #print toReturn
        if toReturn > 0:
            toReturn = math.sqrt(toReturn)
        elif toReturn < 0:
            toReturn = -math.sqrt(-toReturn)
        
        return toReturn        
     
    def GetMoveRequest(self):
        move_value = self.mouseDy*self.TURN_SPEED        
        position_change = [0, 0, 0]
        if move_value > 0:
            move_value = math.sqrt(move_value)
        elif move_value < 0:
            move_value = -math.sqrt(-move_value)
        
        position_change = [move_value, 0, 0]
        
        #print "GetMoveRequest: " + str(position_change)
        
        rotation_value = self.mouseDx*self.TURN_SPEED
        
        if rotation_value > 0:
            rotation_value = math.sqrt(rotation_value)
        elif rotation_value < 0:
            rotation_value = -math.sqrt(-rotation_value)
        
        
        #print "GetMoveRequest (rotation_value): " + str(rotation_value)
        #print "GetMoveRequest: " + str(toReturn)
        toReturn = [0,0,0]
        toReturn[X_POS] = position_change[X_POS] * math.sin(AngleToRadians(rotation_value)) + position_change[Z_POS] * math.cos(AngleToRadians(rotation_value))
        toReturn[Y_POS] = 0
        toReturn[Z_POS] = position_change[X_POS] * math.cos(AngleToRadians(rotation_value)) + position_change[Z_POS] * math.sin(AngleToRadians(rotation_value))
        #print "toReturn" + str(toReturn)
        return toReturn   
        
        
    def updatePrePhysics(self):
        throttle = vizmat.Vector([0,0,0])
        xChange = self.mouseDx * self.TURN_SPEED
        #pitchChange = -self.mouseDy * self.TURN_SPEED            
        
        
        if self.RotationOn == True:
            self.BodyRotation = self.BodyRotation + self.GetRotationRequest()
            self.BodyRotation = NormalizeAngle(self.BodyRotation)            
        
        if self.HeadControlOn == True:
            headEuler = self.head.getEuler(viz.ABS_GLOBAL)
            headEuler[0] = headEuler[0] + xChange
           
            self.head.setEuler(headEuler, viz.ABS_GLOBAL)
            
            
        
        if self.MoveOn == True:
            throttle.set([0,0,0])
            throttle += self.GetMoveRequest()
            throttle.normalize() #<--direction
            if viz.key.isDown(' ') or viz.mouse.getState() & viz.MOUSEBUTTON_MIDDLE:
                throttle *= self.HYPER_THROTTLE_SPEED
                 
            else:
                throttle *= self.THROTTLE_SPEED
                
            if throttle.length(): #if throttle not zero
                #move forward in direction of head
                newVel = vizmat.Transform()
                newVel.setTrans(throttle)            # set translate
                newVel.postEuler(self.head.getEuler(viz.ABS_GLOBAL)) #rotate
                self.velMotor.setVelocity(newVel.getTrans())
                
            else:
                self.velMotor.setVelocity([0, 0, 0])
                
        
        temp_pos = self.feet.getPosition(viz.ABS_GLOBAL)
        
        if (temp_pos[1] >= 0.1):
			print "pos is greater than 0.1 : "+ str(temp_pos)
        
        self.mouseDx = 0
        self.mouseDy = 0
        
    def onMouseMoveTemp(self,e):
        print "mouse on update"
        
    def updatePostPhysics(self):
        
        temp_pos= self.feet.getPosition(viz.ABS_GLOBAL)
        temp_pos[1]=0
        self.feet.setPosition(temp_pos)
        self.feet.setEuler([0, 0, 0])
        
    def onMouseMove(self, e):
        #fuction called twice, once for movement on x axis, once for y axis
        self.mouseDx = self.mouseDx + e.dx
        self.mouseDy = self.mouseDy + e.dy
    
    
    def linkView(self, view):
        return viz.link(self.onTopOfFeet, view, srcFlag=viz.LINK_ABSOLUTE, dstFlag=viz.LINK_POS_RAW)
    
    
     
    def setPosition(self, xyz):
        print "Move Control:setPosition" + str(xyz)
        self.feet.setPosition(xyz)
        
        
    def setEuler(self, euler):
        self.head.setEuler(euler)

def NormalizeAngle(angle_to_normalize):
    while angle_to_normalize < -180:
        angle_to_normalize = angle_to_normalize + 360
        #print "+360"
    while angle_to_normalize > 180:
        angle_to_normalize = angle_to_normalize - 360
        #print "-360"
    return angle_to_normalize

def AngleToRadians(angle):
    return angle/360*2*math.pi




if __name__ == '__main__':
	viz.go()
	viz.move([0, 0, -2])
	viz.phys.enable()
	t = viz.add('tankmaze.wrl')
	t.collideMesh(bounce=0, hardness=1, friction=0)
	user = UserAvatar()
	user.feet.setPosition([0, 0, 0])
	user.linkView(viz.MainView)
	
	
	