#################################################################################
#
# VizUtils
#
#################################################################################


import viz

FLUSH_PERIOD	= 3.0	# seconds


class SaveData(viz.EventClass):
	FLUSH = 1001

	def __init__(self,outputFileName):
		#Initialize the base class
		viz.EventClass.__init__(self)
		
		#Create a callback to our own event class function
		self.callback(viz.TIMER_EVENT,self.mytimer)
		
		#Start a perpetual timer for this event class
		self.starttimer(self.FLUSH, FLUSH_PERIOD, viz.FOREVER)
		self.fileHandle = open(outputFileName, 'a')
		self.monitorList = []
		self.monitorLabel = []
		self.monitorNum  = 0
		
	def monitor(self, what, period, label =''):
		try:
			eval(what)
		except:
			print '** ERROR: SaveData target not a valid expression.'
			print '          Could not eval: ', what
			return
			
		self.monitorList.append(what)
		
		if label != '':
			label += '\t'
		self.monitorLabel = label
		
		self.starttimer(self.monitorNum, period, viz.FOREVER)
		self.monitorNum += 1
		
	def remark(self, message):
		self.fileHandle.write(message + '\n')
		self.fileHandle.flush()
	
		
	def mytimer(self, num):
		if num == self.FLUSH:
			self.fileHandle.flush()
	
		else:
			out = eval(self.monitorList[num])
			outS = str(out)
			outS = outS.replace('[', '')
			outS = outS.replace(']', '')
			outS = outS.replace(',', '\t')
		
			self.fileHandle.write(self.monitorLabel + outS + '\n')
			



class LikertScale(viz.EventClass):

	def __init__(self, where = [0,0,0], scale = 1.0, message = ''):
		#Initialize the base class
		viz.EventClass.__init__(self)

		self.g = viz.add(viz.GROUP)
		q = self.g.add(viz.TEXQUAD)
		q.scale(13,1,1)
		q.translate(0,.3,0)
		t = self.g.add(viz.TEXT3D, '-3 -2 -1  0 +1 +2 +3')
		t.color(0,0,0)
		t.font('cour.ttf')
		t.alignment(viz.TEXT_CENTER_BOTTOM)
		
		self.messageB = self.g.add(viz.TEXT3D, message)
		self.messageB.translate(0, 1, 0)
		self.messageB.alignment(viz.TEXT_CENTER_BOTTOM)
		self.messageB.color(0,0,0)
		self.messageW = self.g.add(viz.TEXT3D, message)
		self.messageW.translate(-.05, 1.05, 0)
		self.messageW.alignment(viz.TEXT_CENTER_BOTTOM)
		self.messageW.color(1,1,1)
		self.messageW.zoffset()
				
		q.zoffset(40)
		t.zoffset(30)
		viz.linewidth(5.0)
		viz.startlayer(viz.LINE_LOOP)
		viz.vertexcolor(1,0,0)
		viz.linewidth(5.0)
		viz.vertex(-.5,0,0)
		viz.vertex(-.5,1,0)
		viz.vertex(.5,1,0)
		viz.vertex(.5,0,0)
		self.reticle = viz.endlayer()
		self.reticle.parent(self.g)
		
		self.g.translate(where[0], where[1], where[2])
		self.g.scale(scale, scale, scale)
			
		#Create a callback to our own event class function
		self.callback(viz.TIMER_EVENT,self.mytimer)
		self.starttimer(1,.1,viz.FOREVER)
		
		self.keyUpOccurred = 0
		self.reticlePos = 0

	def mytimer(self, num):
		
		if viz.iskeydown(viz.KEY_LEFT) and self.keyUpOccurred:
			self.reticlePos -= 1
			self.keyUpOccurred = 0
		elif viz.iskeydown(viz.KEY_RIGHT) and self.keyUpOccurred:
			self.reticlePos += 1
			self.keyUpOccurred = 0
		else:
			self.keyUpOccurred = 1
			
		if self.reticlePos > 3:
			self.reticlePos = 3
		if self.reticlePos < -3:
			self.reticlePos = -3
			
		self.reticle.translate(self.reticlePos * 1.8, -.2, 0)
			
		
	def visible(self, state = viz.ON):
		self.g.visible(state)
		
	def translate(self, x, y, z):
		self.g.translate(x, y, z)
		
	def rotate(self, x, y, z, q):
		self.g.rotate(x,y,z, q)
		
	def set(self, value = 0):
		self.reticlePos = value
		
	def get(self):
		return self.reticlePos
		
	def message(self, message):
		self.messageB.message(message)
		self.messageW.message(message)
		
		
