##############################################################################
####  IMPORT VIZARD AND PYTHON MODULES & CREATE AN EMPTY UNIVERSE		  ####
##############################################################################

import viz			# This is the main Vizard module
import VizUtils   	# This module includes functions for adding Likert scales & easily collecting data
import whrandom 	# This module has a random function
					# python web site has many pre-written functions that can be imported
					
viz.go()			# This creates an empty universe

##############################################################################
####  SET THE WORLD'S PARAMETERS 	  									  ####
##############################################################################


viz.clearcolor(0,0,1)					# Set the background color to blue
viz.translate(viz.HEAD_POS,0,0,-1.5)    # Position the user's viewpoint in the world
viz.eyeheight(1.76)						# Set the user's eyeheight

view = viz.get(viz.MAIN_VIEWPOINT)		# Get the main viewpoint object -- Used for moving the viewpoint
view.collision(viz.ON)					# Turn on collision detection


##############################################################################
####  LOAD OBJECTS & POSITION THEM IN THE WORLD						 	  ####
##############################################################################

viz.add('tut_ground.wrl')  				# Add the ground object

##############################################################################
####  ADD A MALE & FEMALE AVATAR, POSITION THEM, & SET THEIR STATE		  ####
##############################################################################

### Add & Position the Avatars ###
FemaleAvatar = viz.add('female.cfg')  	# Add a female avatar
FemaleAvatar.rotate(0,1,0, 180)			# Rotate her around 180 degrees

MaleAvatar=viz.add('male.cfg')			# Add a male avatar
MaleAvatar.rotate(0,1,0, 180)			# Rotate him around 180 degrees

### Pose the Avatar in a Neutral State ###
FemaleAvatar.state(1)					# Position the female avatar in a neutral state
MaleAvatar.state(1)						# Position the male avatar in a neutral state

### Make the Avatar Invisible ###
FemaleAvatar.visible(0)					# Make the female avatar invisible
MaleAvatar.visible(0)					# Make the male avatar invisible


##############################################################################
####  ADD LIKERT SCALES TO THE WORLD 									  ####
##############################################################################

### ADD A LIKERT SCALE OBJECT & POSITION IT IN THE WORLD ###
likert = VizUtils.LikertScale([0,2.2,1], .15, 'How much do you like me?')
### FORMAT:  Viz.Utils.LikertScale([POSITION], SCALE, 'LABEL')

### SET THE LIKERT SCALE'S PROPERTIES ###
likert.visible(0)			# Make the scale invisible when it is created
likert.set(0)   	 		# Sets the default value on the Likert Scale to 0

##############################################################################
####  INITIALIZE VARIABLES THAT WILL BE USED LATER					  	  ####
##############################################################################

scaleValue = [0,0]   		# This array keeps track of the values of 2 scales 
ActiveScale = 1				# This variable tells which scale (1 or 2) is in use
trial = 0					# Initialize trials
avatar = 0  				# Determines which avatar should I show? (0 = female; 1 = male)
go=0						# Add a variable that keeps track of when the experiment is going or not
MOVE_SPEED = 1				# This variable controls moving the viewpoint (move 5 m/sec)

##############################################################################
####  PROMPT THE EXPERIMENTER FOR INPUT								  	  ####
##############################################################################

### This allows the experimenter to customize each participant's experience
subNum=0    				# This is the subject ID #
subNum=viz.input ('Enter the Participant ID Number: ')

numTrials=0					# This variable controls the number of trials to run
numTrials=viz.input('How many trials do you want to run?')
### This could also be done by using a random function to select the number of
### trials randomly. 


##############################################################################
####ADD A KEYBOARD EVENT TO START THE EXPERIMENT AND RECORD USER RESPONSES####
##############################################################################

def mykeyboard(whichKey):
	
	global ActiveScale, scaleValue, trial, numTrials, avatar, subNum, go
	
	if whichKey == 's':  	#	Press 's' to start the first trial
		go=1				# 	go = 1 means the experiment is active, go = 0 is inactive
		pickAvatar()		# 	Run the pickAvatar function

	elif whichKey==' ':		#When the user presses the space bar, record the value and show the next scale
		if go == 1:			# 	Only accept this keypress when the experiment is active
			
			if ActiveScale==1:		# Do the following if the first scale is the active scale
				print "Current Value for Likert #1 is: ", likert.get()  # print out the current value of the Likert scale
				likert1=likert.get()		#Get the current value of the Likert scale
				scaleValue[0]=likert1		#Record this value in our array so we can use it later
				likert.message('How attractive am I?')	# Change the label on the Likert scale to the 2nd question
				ActiveScale=2				# Make the second scale active
			
			elif ActiveScale==2:	# Do the following if the second scale is the active scale
				print "Current Value for Likert #2 is: ", likert.get()	# print out the current value of the Likert scale
				FemaleAvatar.visible(0) 	# Hide the Female Avatar
				MaleAvatar.visible(0)		# Hide the Male Avatar
				likert.visible(0)			# Hide the Likert Scale
				
				likert2=likert.get()		# Get the value for the second Likert scale
				scaleValue[1]=likert2		# Record the value so we can use it later
				RecordLikertData()			# Run the RecordLikertData function to write out the Likert data for this trial to a file
				ActiveScale=1				# Make the first scale active
				ScaleValue=[0,0]			# Reinitialize the trial data to get ready to collect the next trial
					
				likert.message('How much do you like me?')  # Change the label back to the first question		
				
				pickAvatar()				# Pick the next avatar
			
		print "Likert scale is: ", scaleValue	# Prints out the value of the currently active scale
		print "The Active Scale is: ", ActiveScale	# Prints out which scale is active
	
		
viz.callback(viz.KEYBOARD_EVENT, mykeyboard)  #Adds the keyboard callback function


##############################################################################
####  ADD A TIMER TO LET YOU MOVE FORWARD AND BACK TO INSPECT THE AVATAR  ####
##############################################################################

def mytimer(num):
	
	if viz.iskeydown(viz.KEY_UP):     	# Move forward when the up arrow is pushed
		view.move(0,0,MOVE_SPEED*viz.elapsed(),viz.BODY_ORI)
	
	elif viz.iskeydown(viz.KEY_DOWN):	# Move backwards when the down arrow is pushed
		view.move(0,0,-MOVE_SPEED*viz.elapsed(),viz.BODY_ORI)

viz.callback(viz.TIMER_EVENT,mytimer)	# Adds the timer callback function
viz.starttimer(0,0.01,viz.FOREVER)		# Start the timer

##############################################################################
####  CREATE CUSTOM FUNCTIONS TO CONTROL THE EXPERIMENT					  ####
##############################################################################

def pickAvatar():		#PICK WHICH AVATAR TO DISPLAY
	global ActiveScale, scaleValue, trial, avatar, subNum, go
	
	avatar = whrandom.randint(0,1)   #RANDOMLY DECIDE WHETHER TO DISPLAY A MALE OR FEMALE AVATAR
	trial=trial+1					 #SET THE TRIAL NUMBER
	print "Trial is: ", trial
	### You could also put the different avatars into an array, randomly select one of them
	### and remove them from the array.  This would allow you make sure all avatars are shown
	### a set number of times.  You could also specify the order they are displayed if you prefer.
	
	if trial <= numTrials:	# Check to see if the experiment is still running
		if avatar == 0:  	# Show the female avatar & make the male invisible
			FemaleAvatar.visible(1)
			MaleAvatar.visible(0)
			
		elif avatar == 1: 	# Show the male avatar & make the female invisible
			MaleAvatar.visible(1)
			FemaleAvatar.visible(0)
		
		likert.visible(1)  # Make the Likert Scale Visible
	
	else:				# Do the following if we've run all of the trials
		end_message = viz.add(viz.TEXT3D, "Thank you for your participation", viz.SCREEN)  # Put some text on the screen
		end_message.scale(.8,.8,.8)			# Scale the size of the text
		end_message.translate(.08,.5,0)		# Position the text on the screen
		go=0								# Make the experiment inactive

def RecordLikertData():   # WRITE THE LIKERT DATA OUT TO A FILE
	global ActiveScale, scaleValue, trial, avatar, subNum
	
	LikertData=open('MyLikertData.txt','a')		# Open a data file

	if trial == 1:	# Do the following for the first trial
		# This is the data string to write out
		Data = '\n' + 'Subnum' + '\t' +str(subNum) + '\t' + \
		'Like1' + '\t' + str(scaleValue[0]) + '\t' + \
		'Attract1' + '\t' + str(scaleValue[1]) 
		LikertData.write(Data)							# Write the data
		LikertData.flush()								# Push the data to the file to protect from crashes

	elif trial>1 and trial <=numTrials:  # Do the following for trials 2 - numTrials
		# This is the data string to write out
		Data = '\t' + 'Like' + str(trial) + '\t' + str(scaleValue[0]) + \
		'\t' + 'Attract' + str(trial) + '\t' + str(scaleValue[1]) 
		LikertData.write(Data)	# Write the data
		LikertData.flush()		# Push the data to the file to protect from crashes
		
		if trial==numTrials:	# After the last trial, do the following:
			LikertData.close()	# Close the data file

	print "Data is: ", Data		# Print the data file
	

##############################################################################
####  TRACK HEAD POSITION DATA & WRITE IT OUT TO A FILE					  ####
##############################################################################

TrackingData = VizUtils.SaveData(str(subNum)+'TrackingData.txt')  # Create a data file
TrackingData.remark('This file records tracking data for participant ID# ' + str(subNum))  #add a remark that prints at the beginning of the file
TrackingData.monitor('viz.get(viz.HEAD_POS)', .1, 'Tracking Data:')  #Monitor head position data & write it out to the file every .1/sec

# FORMAT:  ('viz.get(WHAT DO YOU WANT TO GET?)', HOW OFTEN?, 'ADD A TEXT ANNOTATION TO THE FILE')

	# NOTE:  This will monitor head position 10 times/sec and repeatedly write out the
	# participant's head position to a data file callsed "myData.txt'

	