# Sample 3D issue script
# Kit Cuddy (VEMI Lab)
# October 29, 2009
# WorldViz forum ID is GiudiceLab

# This script creates an environment with four soccerballs.  Looking toward the soccerballs
# causes them to quack repeatedly until you look away.  If you move toward a soccerball while
# it is quacking, it gets louder (as expected), but if you then rotate toward the other 
# soccerballs, the sound spatialization seems inconsistent until the viewpoint translates.

import viz
import vizact
import vizinfo

viz.go(viz.FULLSCREEN)

VIEW = viz.MainView
MOVE_SPEED = 2
TURN_SPEED = 20
threshold_angle = 10
floor = viz.add('groundgrid.wrl')

message = vizinfo.add('WASD controls translation\nLeft-Right arrows control orientation')
notes = ['quack.wav','quack.wav','quack.wav','quack.wav']
# Let's put some objects in the room
earheight = 1.65
positions = [[1,earheight,-1],[2,earheight,2],[-1,earheight,1],[-2,earheight,-2]]

objects = []
objplay = []
colors = viz.cycle([viz.RED, viz.YELLOW, viz.GREEN, viz.BLUE])

# We'll make each one a different color and put it somewhere
for item in range(len(positions)):
	objects.append(viz.add('soccerball.ive', color = colors.next(), pos = positions[item]))
	objplay.append(False)

def genTargetAngle(input_pos, startPoint):
	#calculate the angle from the starting point to the target
	def _calcAngle(targetPosition):
		return vizmat.AngleToPoint([startPoint[0],startPoint[2]], targetPosition)
	target_angle = vizmat.HeadAngle(_calcAngle([input_pos[0],input_pos[2]]))
	return target_angle

def toggleTone(item, state):
	# the purpose of this function is turn object sounds on and off.
	global objects
	
	if state == viz.ON:
		objects[item].playsound(notes[item],viz.LOOP)
	if state == viz.OFF:
		objects[item].playsound(notes[item],viz.STOP)

def monitorOri(e):
	global objplay
	# the purpose of this function is to determine whether the viewpoint
	# is facing an object (within a certain threshold)
	# then have that object play its tone until the viewpoint moves outside
	# the threshold
	view_yaw = VIEW.getEuler()
	view_pos = VIEW.getPosition()

	for item in range(len(objects)):
		# compare the angle to each target with the head angle
		object_pos = objects[item].getPosition()
		target_angle = genTargetAngle(object_pos,view_pos)
		relative_angle = abs(vizmat.AngleDiff(target_angle,view_yaw[0]))
		
		if  (relative_angle <= threshold_angle) and objplay[item] == False:
			toggleTone(item,viz.ON)
			objplay[item] = True
		elif (relative_angle > threshold_angle) and objplay[item] == True:
			toggleTone(item,viz.OFF)
			objplay[item] = False
		else:
			pass

def onTimer():
	# keyboard controlled viewpoint
	if viz.iskeydown(viz.KEY_LEFT):
		VIEW.rotate(0,1,0,-TURN_SPEED*viz.elapsed(),viz.HEAD_ORI,viz.REL_PARENT)
	elif viz.iskeydown(viz.KEY_RIGHT):
		VIEW.rotate(0,1,0,TURN_SPEED*viz.elapsed(),viz.HEAD_ORI,viz.REL_PARENT)
	if viz.iskeydown('w'):
		VIEW.translate(0,0,MOVE_SPEED*viz.elapsed(),viz.REL_LOCAL)
	elif viz.iskeydown('s'):
		VIEW.translate(0,0,-MOVE_SPEED*viz.elapsed(),viz.REL_LOCAL)
	elif viz.iskeydown('a'):
		VIEW.translate(-MOVE_SPEED*viz.elapsed(),0,0,viz.REL_LOCAL)
	elif viz.iskeydown('d'):
		VIEW.translate(MOVE_SPEED*viz.elapsed(),0,0,viz.REL_LOCAL)
		
vizact.onupdate(0,onTimer)
viz.callback(viz.UPDATE_EVENT,monitorOri)