# A pySonic example
# Kit Cuddy 08-05-2009

# This code snippet is a very simple example of using pySonic to allow sound output to two different devices simultaneously.
# Only one pySonic "World" can be used at a time (World initializes pySonic), so we have used pySonic to create a 'secondary'
# output device while Vizard's built-in sound libraries handle the sound for the 'primary' (Windows default) device.

# To get this example to work, pySonic (pySonic.pyd) and the fmod library (fmod.dll) need to be in the working directory.

# When this code is run, you will be presented with a dropdown list of sound devices, which pySonic refers to as 'drivers.'
# The first one ('Primary Sound Driver') is your Windows default device.  The second one is likely the device that is
# assigned as the default device.

import pySonic
import viz
import vizact
import vizinfo

# This code will detect existing drivers, but it doesn't automatically use the correct values for mixing rate, etc.
# Tim and I figured out our parameters by first setting the desired device as the default Windows and initializing pySonic:
#w = pySonic.World()
# then outputting the values using:
#print w.MixingRate, w.MaxChannels, w.Output, w.Driver, w.Mixer
# and then using/tweaking the values to create a custom world using these arguments:
# w = pySonic.World(MixingRate, MaxChannels, Output, Driver, Mixer)
# Since then, we figured out that w.Output = pySonic.Constants.FSOUND_OUTPUT_(whatever) and that DSOUND (DirectSound) = 2,
# which is what we need to use 3D sound ( WINMM = 1, NOSOUND = 0, there are others for other OSs )
# The constants can be found in the FMOD documentation, and appear to be listed in order (the actual values of the constants 
# are not listed, but you can find out what they are by using the Vizard command line to return the value)

# This command lists all available sound drivers
#print pySonic.ListDrivers(-1)

# Create a list of the existing drivers
devicelist = pySonic.ListDrivers(-1)
devices = []
for row in range(len(devicelist)):
	devices.append(devicelist[row][0])

# Present a selection box to the user
selection = viz.choose('Which device?',devices)

# Initialize pySonic with the selected device
# These are the values you might need to tweak to get sound from your secondary
# Make sure that your sound card/device is not muted first!
w = pySonic.World(48000,32,100,2,selection,7)

# Load a sound for primary audio
sound1 = viz.addAudio('ding.wav')

# Create a sound source for the secondary audio
sound2 = pySonic.Source()
# Load a sound for secondary audio
sound2.Sound = pySonic.FileSample('ding.wav')

# create a function to call when the button is pressed
def playit():
	sound2.Play()

# assign keys to play sounds
vizact.onkeydown( 'p', sound1.play )
vizact.onkeydown( 's', playit )

# Put instructions on the screen
info = vizinfo.add('Press p to hear the primary device (Windows default)\nPress s to hear the secondary device')
 
viz.go()