
import viz,vizact,random,viztask,vizcam
viz.go()
viz.phys.enable()
# Add avatar
avatar = viz.add('vcc_female.cfg')
avatar.setPosition(0,0,1)
avatar.state(2)
##Walking 
keycontrol = vizcam.KeyboardCamera(forward=viz.KEY_UP,backward=viz.KEY_DOWN,turnRight=viz.KEY_RIGHT,turnLeft=viz.KEY_LEFT)
viz.cam.setHandler(keycontrol)
view = viz.MainView
link = viz.link(view, avatar)
link.preTrans([0,-1.8,4])
## Avatar state
pos = avatar.getPosition()
def checkState():
	global pos
	if pos == avatar.getPosition():
		avatar.state(1)
	else:
		pos = avatar.getPosition()
		avatar.state(2)
		
vizact.ontimer(.1, checkState)
## Avatar's Speed 
avspeed=1
def speedkey(key):
	global avspeed
#Increase speed 
	if key == ' ':
		avspeed = avspeed + .1
		avatar.speed(avspeed)
		keycontrol.sensitivity(avspeed,1)
#Decrease speed 
	if key == '-':
		avspeed = avspeed - .1
		if avspeed>0:
			avatar.speed(avspeed)
			keycontrol.sensitivity(avspeed,1)
viz.callback(viz.KEYBOARD_EVENT,speedkey)
shape = avatar.collideBox()
shape.setDensity(10)
## Add balloons

balloons = []
balloon = viz.add('art/balloon.ive')
def action():
##Add some balloons.
	global balloon
	za=avatar.getPosition()[2]
	for i in range(1,2):
		balloon = viz.add('art/balloon.ive')
		balloon.setPosition( .5,2.3,za+5 )
		R = random.random()
		G = random.random()
		B = random.random()
		balloon.color( R, G, B )
		balloon.specular( viz.WHITE )
		balloon.shininess( 128 )
		balloon.setScale(9,9,9)
		balloon.setEuler(0,-90,0)
		balloon.collideSphere()
		#balloon.enable(viz.COLLIDE_NOTIFY)
		balloon.disable(viz.DYNAMICS)
		balloons.append( balloon )
	
	yield viztask.waitTime(4.5)
	print 'mohammad'
	for balloon in balloons:
		balloon.visible(viz.OFF)
def runfunc1():
	viztask.schedule(action())


handballoon = viz.add('balloon.ive',scale=[0.1,0.1,0.1])
handballoon.collideSphere()
handballoon.disable(viz.DYNAMICS)
handballoon.enable(viz.COLLIDE_NOTIFY)
handballoon_link= viz.link( avatar.getBone('Bip01 R Hand') , handballoon )
handballoon_link.preTrans([0.05,-0.05,0])
#handballoon.disable(viz.RENDERING)
#Hit Balloon
def mousebutton (button):
	arm=avatar.getBone('Bip01 R UpperArm')
	if button == viz.MOUSEBUTTON_LEFT:
		arm.lock()
		arm.setAxisAngle(0,0,1,-2)
		print 'aram', arm.getPosition()
	if button == viz.MOUSEBUTTON_RIGHT:
		arm.unlock()
viz.callback(viz.MOUSEBUTTON_EVENT, mousebutton)
colors = viz.cycle([viz.WHITE,viz.BLUE,viz.RED])
def onCollideBegin(e):
	if e.obj1 == handballoon:
			
		if e.obj2==balloon:
			print '"Yes Balloon has been touched" :',e.obj2
			viz.callback(balloon,balloon_popping_task())
			balloon.color(colors.next())

viz.callback(viz.COLLIDE_BEGIN_EVENT,onCollideBegin)

#Add text fields to a dictionary.
text_dict = {}
for kind in ['score','instructions','time' ]:
	text = viz.addText('', viz.SCREEN )
	text.setScale( .5,.5)
	text.alignment( viz.TEXT_CENTER_BASE )
	text.alpha( 1 )
	text_dict[ kind ] = text
text_dict['score'].setPosition( .1,.9 )
text_dict['instructions'].setPosition( .5,.5 )
text_dict['time'].setPosition( .1,.85 )
def set_the_stage():
	viz.mouse( viz.OFF )
	#Make the instructions text appear.
	text = text_dict[ 'instructions' ]
	text.alpha( 1 )
	#Put a message in that text.
	text.message( 'Press s to begin.' )
	#Wait for the s key to be hit.
	yield viztask.waitKeyDown( 's' )
	text.message( '' )

def game_instructions():
	text = text_dict[ 'instructions' ]
	text.alpha( 1 )
	sentences = ['You will get one point for each balloon that you pop.', 
	'You are racing against the clock.',
	'Get ready . . .' ]
	for sentence in sentences:
		text.alpha(0)
		text.message( sentence )
		#Add a fading action to the text and wait.
		yield viztask.addAction( text, vizact.fadeTo(1, time = 1 ))
		#Wait a second.
		yield viztask.waitTime( 1 )
		#Wait to fade out.
		yield viztask.addAction( text, vizact.fadeTo(0, time = 1 ))

def game_timer_task():
	#Grab the text field for
	#time.
	text = text_dict[ 'time' ]
	time = 0
	text.message( 'Time: 0' )
	#Loop through as long as time is under a certain number of seconds.
	while time < 100:
		yield viztask.waitTime( 1 )
		time += 1
		text.message( 'Time: ' + str( time ) )

def balloon_popping_task():
	#Grab the text field for the score.

#	text = text_dict[ 'score' ]
#	score = 0
#	text.message( 'Score: 0' )
#	#Loop through as long as the score is below the winning limit.
#	data = viz.Data()
#		#Yield for collision events.
#	yield viztask.waitEvent( viz.COLLIDE_NOTIFY, data )
#	#From the data object, get the object that the viewpoint collided with.
#	#intersected_object = data.data[0]
#		#If it was a balloon, pop it and add a point to the score.
#		#pop.play()
#	score += 1
#	text.message( 'Score: ' + str( score ) )
	#Grab the text field for
	#the score.
	text = text_dict[ 'score' ]
	score = 0
	text.message( 'Score: 0' )
	#Loop through as long as the score is below the winning limit.
	while score <3:
		#Create a data object to accept data from the event.
		data = viz.Data()
		#Yield for collision events.
		yield viztask.waitEvent( viz.COLLISION_EVENT, data )
		#From the data object, get the object that the viewpoint collided with.
		intersected_object = data.data[0].object
		#If it was a balloon, pop it and add a point to the score.
		if balloons.count( intersected_object ):
			#pop.play()
			score += 1
			text.message( 'Score: ' + str( score ) )
			intersected_object.visible( viz.OFF )
		
def game():
	#Begin the game and Turn on mouse navigation.
	viz.mouse( viz.ON )
	#Make the subwindow visible.
	#subwindow.visible( viz.ON )
	#Get rid of the blank screen that blocks the view.
	#blank_screen.visible( viz.OFF )
	
	vizact.ontimer(5,runfunc1)
	#Create two tasks for two outcomes of game.
	balloon_popping = viztask.waitTask( balloon_popping_task() )
	time_passing = viztask.waitTask( game_timer_task() )
	
	#Wait for the game to end
	data = viz.Data()
	#Wait for the game to end one way or another.
	yield viztask.waitAny( [balloon_popping, time_passing], data )
	
	#Once the game has ended, hide things.
	viz.mouse( viz.OFF )
	#blank_screen.visible( viz.ON )
	#subwindow.visible( viz.OFF )
	viz.MainView.reset(viz.HEAD_ORI | viz.HEAD_POS| viz.BODY_ORI)
		
	#Give different feedback depending on how the game ended.
	text = text_dict[ 'instructions' ]
	if data.condition == balloon_popping:
		text.message( 'GAME OVER, YOU WON!' )
	elif data.condition == time_passing:
		text.message( 'GAME OVER, YOU LOST.' )
	text.alpha( 1 )
	
	#Wait a moment.
	yield viztask.waitTime( 4 )

def main_sequence():
	while True:
		
		#Set the stage for the game.
		yield set_the_stage()
		#Begin with instructions.
		yield game_instructions()
		#Play the game.
		yield game()
#Schedule the main sequence task.
viztask.schedule( main_sequence() )
	
	