import viz

class TableGUI(viz.VizNode):
	#tabel coordinate system: upper left is zero
	COLUMN_WIDTH = .085
	ROW_HEIGHT = .05
	TEXT_SIZE = 0.425
	TEXT_OFFSET = [.003, .005]
	def __init__(self, parent, pos=None, scale=None, alpha=1, doubleArray=None, **kw):
		self.tableArray = [[]] #columns then rows
		self.columnGraphics = [] #nodes that represent columns
		
		self.__root = viz.addGroup(parent, pos=pos, scale=scale)
		viz.VizNode.__init__(self, self.__root.id, **kw)
		self.alphaValue = alpha
		self.alpha(self.alphaValue)
		viz.startlayer(viz.QUADS)
		viz.vertexcolor(viz.WHITE)
		viz.vertex(0, 0, 0)
		viz.vertex(0, 0, 0)
		viz.vertex(0, 0, 0)
		viz.vertex(0, 0, 0)
		self.background = viz.endlayer(parent=self)
		self.background.alpha(self.alphaValue)
		self.background.setPosition([0,0,.005])
		self.background.zoffset(2)
		self.background.draworder(11)
		
		viz.startlayer(viz.LINE_LOOP)
		viz.vertexcolor(viz.BLACK)
		viz.linewidth(3)
		viz.vertex(0, 0, 0)
		viz.vertex(0, 0, 0)
		viz.vertex(0, 0, 0)
		viz.vertex(0, 0, 0)
		self.border = viz.endlayer(parent=self)
		
		self._columnWidth = self.COLUMN_WIDTH
		self._textSize = self.TEXT_SIZE
		self._rowHeigth = self.ROW_HEIGHT
		
		if doubleArray:
			self.update(doubleArray)
	
	def setTextSize(self, newSizeFactor):
		self._textSize = self.TEXT_SIZE * newSizeFactor
	def setColumnWidth(self, newWidthFactor):
		self._columnWidth = self.COLUMN_WIDTH * newWidthFactor
	
	def getRowCount(self):
		if len(self.tableArray) > 0:
			return len(self.tableArray[0])
		else:
			return 0
		
	def getColumnCount(self):
		return len(self.tableArray)
		
	def getCellPos(self, columnIndex, rowIndex):
		return [self._columnWidth*columnIndex, -self._rowHeigth*rowIndex]
		
	def update(self, doubleArray=None):
		if doubleArray:
			self.tableArray = doubleArray
		columnCount = self.getColumnCount()
		rowCount = self.getRowCount()
		
		upperLeft = [0, 0]
		lowerLeft = [0, -self._rowHeigth*rowCount]
		lowerRight = [self._columnWidth*columnCount, -self._rowHeigth*rowCount]
		upperRight = [self._columnWidth*columnCount, 0]
		self.background.setVertex(1, [lowerLeft[0], lowerLeft[1], 0])
		self.background.setVertex(2, [lowerRight[0], lowerRight[1], 0])
		self.background.setVertex(3, [upperRight[0], upperRight[1], 0])
		
		self.border.setVertex(1, [lowerLeft[0], lowerLeft[1], 0])
		self.border.setVertex(2, [lowerRight[0], lowerRight[1], 0])
		self.border.setVertex(3, [upperRight[0], upperRight[1], 0])
		
		for i, column in enumerate(self.tableArray):
			if i > (len(self.columnGraphics)-1):
				#new column graphics
				columnRoot = viz.addGroup(parent=self)
				columnRoot.draworder(12)
				viz.startlayer(viz.LINES)
				viz.vertexcolor(viz.BLACK)
				viz.vertex(0, 0, 0)
				viz.vertex(0, 0, 0)
				columnRoot.leftLine = viz.endlayer(parent=columnRoot)
				columnRoot.leftLine.alpha(self.alphaValue)
				columnRoot.cellGraphics = []
				self.columnGraphics.append(columnRoot)
				
			#ajust column graphics
			columnRoot = self.columnGraphics[i]
			columnRoot.setPosition(self.getCellPos(i, 0)+[0])
			bottomY = self.getCellPos(0, self.getRowCount())[1]
			columnRoot.leftLine.setVertex(1, [0, bottomY, 0])
				
			for j, cell in enumerate(column):
				if j > (len(columnRoot.cellGraphics)-1):
					#new cell graphics
					cellRoot = viz.addGroup(parent=columnRoot)
					viz.startlayer(viz.LINES)
					viz.vertexcolor(viz.BLACK)				
					viz.vertex([0,0,0])
					viz.vertex([0,0,0])					
					cellRoot.bottomLine = viz.endlayer(parent=cellRoot)
					cellRoot.text = viz.addText(cell, parent=cellRoot, color=viz.BLACK)
					cellRoot.text.alpha(self.alphaValue)
					columnRoot.cellGraphics.append(cellRoot)
					
				#ajust cell graphics
				cellRoot = columnRoot.cellGraphics[j]
				cellRoot.setPosition(self.getCellPos(0, j)+[0])
				cellRoot.bottomLine.setVertex(0, self.getCellPos(0, 1)+[0])
				cellRoot.bottomLine.setVertex(1, self.getCellPos(1, 1)+[0])
				textPos = self.getCellPos(0, 1)+[0]
				textPos[0] += self.TEXT_OFFSET[0]
				textPos[1] += self.TEXT_OFFSET[1]
				cellRoot.text.setPosition(textPos)
				cellRoot.text.message(cell)
				cellRoot.text.setScale([self._textSize]*3)
			
			#cleanup old cell graphics
			countToRemove = max(0, len(columnRoot.cellGraphics) - len(column))
			removeMe = columnRoot.cellGraphics[len(columnRoot.cellGraphics)-countToRemove:]
			for node in removeMe:
				node.remove()
			del columnRoot.cellGraphics[len(columnRoot.cellGraphics)-countToRemove:]
				
		#cleanup old column graphics
		countToRemove = max(0, len(self.columnGraphics) - len(self.tableArray))
		removeMe = self.columnGraphics[len(self.columnGraphics)-countToRemove:]
		for node in removeMe:
			node.remove()
		del self.columnGraphics[len(self.columnGraphics)-countToRemove:]
	
	def getTextNodes(self):
		table = []
		for column in self.columnGraphics:
			columnText = []
			for cell in column.cellGraphics:
				columnText.append(cell.text)
			table.append(columnText)
		return table
		
	def getCellNodes(self):
		table = []
		for column in self.columnGraphics:
			columnText = []
			for cell in column.cellGraphics:
				columnText.append(cell)
			table.append(columnText)
		return table
		
	def getColumnNodes(self):
		table = []
		for column in self.columnGraphics:
			table.append(column)
		return table	
		
	def setColor(self, color):
		for column in self.getTextNodes():
			for text in column[1:]: #skip column headers
				text.color(color)
	
class ScreenTableGUI(TableGUI):
	COLUMN_WIDTH = .085
	ROW_HEIGHT = .05
	TEXT_SIZE = COLUMN_WIDTH * 5
	TEXT_OFFSET = [.003, .005]
	
	def __init__(self, parent=viz.SCREEN, **kw):
		TableGUI.__init__(self, parent, **kw)
		
class OrthoTableGUI(TableGUI):
	COLUMN_WIDTH = .085
	ROW_HEIGHT = .05
	TEXT_SIZE = COLUMN_WIDTH * 5
	TEXT_OFFSET = [.003, .005]
	
	def __init__(self, parent=viz.ORTHO, **kw):
		TableGUI.__init__(self, parent, **kw)
		
if __name__ == '__main__':
	viz.go()
	viz.add('gallery.ive')
	viz.clearcolor(viz.SKYBLUE)
	
	table = OrthoTableGUI(pos=[100, 300, 0], scale=[1]*3)
	parameters = [ ['ortho', '12.22', '2', '3'], ['G', 'a', 'bdsf', ''] ]	
	table.update(doubleArray=parameters)	#fill table with list of lists
	
	table = ScreenTableGUI(pos=[.3,.5,0], scale=[1]*3)
	parameters = [ ['v0', '12.22', '2', '3'], ['G', 'a', 'bdsf'] ]	
	table.update(doubleArray=parameters)	#fill table with list of lists
	
	parameters = [ ['v0', 'ads', '2', '3'], ['G', 'a', 'b', 'c'], ['deg', '.1', '.01', '.001'] ]
	table.setColumnWidth(1.5)
	table.update(doubleArray=parameters) #only the new list of lists is displayed with one extra column.
	
	#color each row a different color
	colorList = [viz.RED, viz.GREEN, viz.BLUE]
	for column in table.getTextNodes():
		if len(column) > 0:
			for i, text in enumerate(column[1:]): #skip column header
				text.color(colorList[i])


	#create screen-saver-ish table
	parameters = [ ['v0', '3.15'], ['G', 'a'], ['deg', '.1'] ]
	flyingTable = ScreenTableGUI(pos=[.6,.2,0], scale=[1.5]*3, alpha=.8, doubleArray=parameters)
	def screenSaverTask(nodeToMove):
		velocityVector = vizmat.Vector([-.4, .3, 0])
		colorCycle = viz.cycle([viz.RED, viz.BLUE, viz.GREEN])
		while True:
			amountToMove = velocityVector * viz.getFrameElapsed()
			newPos = amountToMove + nodeToMove.getPosition()
			normalVector = None
			if newPos[0] < 0: #collided with left edge of screen				
				normalVector = [1, 0, 0]
			elif newPos[0] > 1: #collided with right edge of screen
				normalVector = [-1, 0, 0]
			elif newPos[1] < 0: #collided with bottom edge of screen
				normalVector = [0, 1, 0]
			elif newPos[1] > 1: #collided with bottom edge of screen
				normalVector = [0, -1, 0]
			
			if normalVector:
				#reflect node
				velocityVector = vizmat.Vector(vizmat.ReflectionVector(velocityVector, normalVector))
				nodeToMove.setColor(colorCycle.next())
			else:
				#move node
				nodeToMove.setPosition(newPos)
				
			yield None #wait frame
	
	import viztask
	viztask.schedule(screenSaverTask(flyingTable))
	
	#test for memory leaks
#	for i in range(300):
#		stuff = [ ['v0', '1.0', '2.0', '3.0'], ['G', 'aa', 'bb', 'cc'], ['deg', '.2', '.01', '.001'] ]
#		t.update(doubleArray=stuff)	
		