#Copyright Jon Berg , turtlemeat.com

import string,cgi,time
from os import curdir, sep
from BaseHTTPServer import BaseHTTPRequestHandler, HTTPServer
from CGIHTTPServer import CGIHTTPRequestHandler
import cgi

import httplib

import vizact, viz

RECEVED_TEST_DATA_EVENT = viz.getEventID('RECEVED_TEST_DATA_EVENT')

class MyHandler(CGIHTTPRequestHandler):

	def do_POST(self):
		global rootnode
		self.send_response(301)
		
		self.send_header('Content-type',	'text/html')
		self.end_headers()
		
		rawForm = self.rfile.read(int(self.headers['Content-Length']))
		parseDic = cgi.parse_qs(rawForm)
		
		stringy = r'<html><head></head><body>POST OK.</body></html>'
		self.wfile.write(stringy)
		
		e = viz.Event()
		e.resultsDic = parseDic
		viz.sendEvent(RECEVED_TEST_DATA_EVENT, e)
				

	def do_QUIT (self):
			"""send 200 OK response, and set server.stop to True"""
			self.send_response(200)
			self.end_headers()
			self.server.stop = True

class StoppableHttpServer(HTTPServer):
    """http server that reacts to self.stop flag"""

    def serve_forever (self):
        """Handle one request at a time until stopped."""
        self.stop = False
        while not self.stop:
            self.handle_request()


def stop_server():
    """send QUIT request to http server running on localhost:<port>"""
    conn = httplib.HTTPConnection("localhost:80")
    conn.request("QUIT", "/")
    conn.getresponse()


import threading

class WebServerThread(threading.Thread):

	def run(self):
		try:
			server = StoppableHttpServer(('', 80), MyHandler)
			print 'started httpserver...'
			server.serve_forever()
		except KeyboardInterrupt:
			print '^C received, shutting down server'
			server.socket.close()

global server
def startWebServer():
	viz.directormode(viz.DIRECTOR_FAST) #allow the web server thread to get CPU time during rendering
	global server
	server = WebServerThread()
	server.start()
	vizact.onevent(viz.EXIT_EVENT, lambda : (True, None),onQuit)
	
def onQuit():
	stop_server()
	

if __name__ == '__main__':
	import viz
	viz.go()
	viz.add('gallery.ive')
	startWebServer()
	
#	viz.window.displayHTML('test.html')

