'''

Hotpotato install:
Install Hot Potatoes

Create Quiz:
In Config diaolog, other tab, uncheck create external javascript file
In Config diaolog, CGI tab, check Submit resulsts and set URL to http://127.0.0.1
Under menu options->source directory to 'phys_ed_hotpot_source'
export html quiz
Copy phys-ed-hotpot-mod.js into the same directory as the html page.  

'''

import viz
import viztask

import WebServer
import vizinfo

infoGUI = None
isSetup = False
simOrQuiz = None
def setup():
	global isSetup, infoGUI, simOrQuiz
	WebServer.startWebServer()
	isSetup = True
	infoGUI = vizinfo.add('')
	infoGUI.scale(1.8,1.8)
	infoGUI.alignment(vizinfo.UPPER_LEFT)
	infoGUI.bgcolor((0.3,0.3,.5),.85)
	infoGUI._checkbox.visible(viz.OFF)
	infoGUI.translate(0.3, 0.7)
	infoGUI._group.parent(viz.SCREEN, scene=2)

	infoText = infoGUI.add(viz.TEXT3D, 'Loading Question...')
	infoGUI.visible(viz.OFF)
	
	simOrQuiz = vizinfo.add('See next question or virtual experiment?')
	simOrQuiz.scale(1.8,1.8)
	simOrQuiz.alignment(vizinfo.UPPER_LEFT)
	simOrQuiz.bgcolor((0.3,0.3,.5),.85)
	simOrQuiz._checkbox.visible(viz.OFF)
	simOrQuiz.translate(0.1, 0.7)
	simOrQuiz._group.parent(viz.SCREEN, scene=2)

	simOrQuiz.nextQuestionButton = simOrQuiz.add(viz.BUTTON, 'Next Quiz')
	simOrQuiz.expButton = simOrQuiz.add(viz.BUTTON, 'Virtual Experiment')
	simOrQuiz.visible(viz.OFF)
	
	
def doQuestion(question):
	viz.scene(2)
	if not isSetup:
		setup()
	
	infoGUI.visible(viz.ON)
	viz.window.displayHTML(question.fileName, size=[800,800])
#	viz.window.displayHTML(question.fileName)
	e = viz.Data()
	yield viztask.waitEvent(WebServer.RECEVED_TEST_DATA_EVENT, e)
	infoGUI.visible(viz.OFF)
#	viz.window.hideHTML()
	
	resultsDic = e.data[0].resultsDic
	for key in resultsDic:
		print key, ':', resultsDic[key]
	
	logString = ''
	if resultsDic.has_key('Exercise'):
		logString += resultsDic['Exercise'][0] + '\t'
	else:
		logString += ' ' + '\t'
	if resultsDic.has_key('Score'):
		logString += resultsDic['Score'][0] + '\t'
	else:
		logString += ' ' + '\t'
		
#	LogRecorder.write(logString)
	
	#parse results
	if e.data[0].resultsDic['Score'][0] == '100%':
		question.setIsTestPassed(True)
		simOrQuiz.visible(viz.ON)
		d = viz.Data()
		nextQuestion = viztask.waitButtonUp(simOrQuiz.nextQuestionButton)
		exp = viztask.waitButtonUp(simOrQuiz.expButton)
		yield viztask.waitAny([nextQuestion, exp], data=d)
		simOrQuiz.visible(viz.OFF)
		if d.condition == exp:
			question.isExperimentNext = True
	else:
		question.setIsTestPassed(False)
	
if __name__== '__main__':
#	viz.go(viz.FULLSCREEN)
	viz.go()
	viz.window.setSize(1000, 1000)
	setup()
	import Question
	viztask.schedule(doQuestion(Question.Question('quizzes/flattrack_position/quiz.htm')))

	