import viz
viz.go()

viz.clearcolor(viz.SKYBLUE)
viz.MainView.setPosition(0,.5,0)


#here are two road textures with different line count in the middle
road = viz.add('road.jpg')
road2 = viz.add('road2.jpg')

#add the ground
ground = viz.add('tut_ground.wrl')
ground.setPosition(0,0,25)

#create a texture quad to add the road texture to
#and place it over ground
quad = viz.addTexQuad()
quad.setScale(1,2,1)
quad.setPosition(0,.1,0)
quad.setEuler(0,90,0)
quad.texture(road)

road_position = 0
ground_position = 75
#add road and ground if getting near the end of road
def addRoad():
	
	global road_position, ground_position
	
	viewpoint_pos = viz.MainView.getPosition()
	#check to see how close the viewpoint is to the end of the road
	if road_position - viewpoint_pos[2] < 25:
		
		#add 50 meters of ground
		global ground_position
		groundcopy = ground.copy()
		groundcopy.setPosition([0,0,ground_position])
		ground_position +=50
		
		#add 50 meters of road
		for i in range(1,50):
			quadcopy = quad.copy()
			quadcopy.setPosition([0,.1,road_position])
			quadcopy.setEuler(0,90,0)
			road_position +=1

addRoad()
#call a timer every second to check if road needs to be added
vizact.ontimer(1, addRoad)

#change the road texture on keypress
vizact.onkeydown('1', quad.texture,road2)
vizact.onkeydown('2', quad.texture,road)