#This class illustrate how to resolve mathematical equation with one Parameter
#OneParaEquation.py

import viz
import vizact
import viztask
import math
import random
import vizinfo
import vizmenu
import time

import PubClasses

class OneParameterEquation(viz.EventClass):
	def __init__(self):
		viz.EventClass.__init__(self)
		viz.clearcolor(.5,.5,1)
		viz.phys.enable()
		viz.collision(viz.OFF)
		viz.mouse(viz.OFF)
		viz.window.setName('Welcome to Mathematics Class')	
		self.Equation_EVENT=viz.getEventID('EQUATION_EVENT')
	def load(self):
		self.itemList_main=[]
		PubClasses.myNavigation.allow(False)
		self.bgSound=PubClasses.playBackgroundSound('c:\\VirtualWorlds\\sound\\SMWTitleScreen.mp3')
		self.itemList_main.append(self.bgSound)
		self.bgSound.play()
		viz.MainView.setPosition(25, 20, -200)
		viz.MainView.setEuler(-18, 1, 0)
		viz.MainView.goto(23,2,-2,60)
		viz.MainView.lookat(23,2,-2)
		[x,y,z]=viz.MainView.getPosition()
		light_mainView = viz.addLight()
		light_mainView.enable()
		light_mainView.position(x,y+0.5, z)
		light_mainView.color([1.0, 1.0, 1.0])
		light_mainView.spread(170)
		light_mainView.intensity(2.5) 
		light_mainView_Link = viz.link(viz.MainView, light_mainView)
		light_mainView_Link.preTrans([0, 0.2, 0]) 
		self.itemList_main.append(light_mainView_Link)
		self.itemList_main.append(light_mainView)
		#main screen & billboard & apple -- delete some components
		self.mainScene = viz.add('c:\\VirtualWorlds\\table\\poolTableScene.3DS')
		self.deletePoolrack = self.mainScene.getChild('poolrack')
		self.deletePoolcue = self.mainScene.getChild('poolcue')
		self.deleteCueball = self.mainScene.getChild('cueball')
		self.deletePoolrack.remove()
		self.deletePoolcue.remove()
		self.deleteCueball.remove()
		for m in [1,2,3,4,5,6,7,8,9]:
			self.delbal01To09 = self.mainScene.getChild('ball0'+str(m))
			self.delbal01To09.remove()
		for n in range(6):
			self.delbal10To15 = self.mainScene.getChild('ball1'+str(n))
			self.delbal10To15.remove()
#		self.mainScene.setScale(5,5,5)
		self.mainScene.setPosition(14,-1,-30)
		self.mainScene.rotate(0,1,0,-11.2)
		self.itemList_main.append(self.mainScene)
		self.teacher = viz.add('c:\\Program Files\\WorldViz\\Vizard30\\resources\\vcc_female.cfg')
		self.teacher.setPosition(21,0,6)
		self.teacher.setEuler(-180,0,0)
		self.teacher.state(14)
		self.billboard2 = viz.add('c:\\VirtualWorlds\\table\\billboard.3DS')
		self.billboard2.setPosition(22.7,-2.5,7.5)
		self.billboard2.setScale(2.5,2.5,2.5)
		self.billboard2.rotate(0,1,0,-10)
		self.speech = vizact.speak('c:\\VirtualWorlds\\table\\jfk.wav') # should change the Sound file
		self.teacher.addAction(self.speech)
		self.slide = viz.add('c:\\VirtualWorlds\\table\\slideQuestion.jpg')
		self.billboard2.texture(self.slide)
		self.registerOnkeydownFunctions(True) #register onkeydown functions
		self.infor = vizinfo.add('Click 0/1/2 to learn step by step')
		self.infor.translate(0.98,0.1)
#click the keyboard step by step
	def registerOnkeydownFunctions(self, createIt=True):
		if createIt == True:
			self.registeredFuncs = []
			self.registeredFuncs.append( vizact.onkeydown('0', self.changeView, 0) ) 
			self.registeredFuncs.append( vizact.onkeydown('1', self.changeView, 1) ) 
			self.registeredFuncs.append( vizact.onkeydown('2', self.changeView, 2) ) 
		else: 
			for callbackfunc in self.registeredFuncs: vizact.removeEvent(callbackfunc) 
	
	def appleVisible(self):
		self.apple.remove()
		
		
#teaching step by step 
	def changeView(self, viewID): 
		if viewID == 0:
		#---voice from Teacher ##we should add some more teaching voice in further steps
			self.bgSound.remove()
			self.speech = vizact.speak('c:\\VirtualWorlds\\table\\jfk.wav')
			self.teacher.addAction(self.speech)
			self.slide = viz.add('c:\\VirtualWorlds\\table\\slideQuestion.jpg')
			self.billboard2.texture(self.slide)
			for x2 in [0, 0.2, 0.4, 0.6, 0.8]: ######right side apples
				for z2 in [0, 0.3, 0.6, 0.9]:
					self.apple = viz.add('c:\\VirtualWorlds\\table\\apple.3DS')
					self.apple.translate(23.2+x2, 0.46, 4.7-z2)
					self.apple.setScale(0.015,0.015,0.015)
			for x1 in [0, 0.2, 0.4, 0.6, 0.8]: #####left side apples
				for z1 in [0, 0.3]:
					self.apple = viz.add('c:\\VirtualWorlds\\table\\apple.3DS')
					self.apple.translate(21.2+x1, 0.46, 4.4-z1)
					self.apple.setScale(0.015,0.015,0.015)
		elif viewID == 1: 
#			self.speech = vizact.speak('c:\\VirtualWorlds\\table\\VOICE.wav')
#			self.teacher.addAction(self.speech)
			self.slide = viz.add('c:\\VirtualWorlds\\table\\slide1.jpg')
			self.billboard2.texture(self.slide)
			
			#			self.apple.visible(False) #########----????? why apples still exist?
			#self.apple.remove()
			
			for b in [0, 0.3]:  ### right side apples
				for a in [0, 0.2, 0.4, 0.6, 0.8]:
					self.apple = viz.add('c:\\VirtualWorlds\\table\\apple.3DS')
					self.apple.translate(23.2+a, 0.46, 4.4-b)
					self.apple.setScale(0.015,0.015,0.015)
		elif viewID == 2: 
#			self.speech = vizact.speak('c:\\VirtualWorlds\\table\\VOICE.wav') # add teacher's voice
#			self.teacher.addAction(self.speech)
			self.slide = viz.add('c:\\VirtualWorlds\\table\\slide2.jpg')
			self.billboard2.texture(self.slide)
			
			#???  self.apple.remove() ################ #---??? why apples still exist?
			
			for z3 in [0, 0.3, 0.6, 0.9]:  ### right side apples 
				for x3 in [0, 0.2, 0.4, 0.6, 0.8]:
					self.apple = viz.add('c:\\VirtualWorlds\\table\\apple.3DS')
					self.apple.translate(23.2+x3, 0.46, 4.7-z3)
					self.apple.setScale(0.015,0.015,0.015)
					
		
viz.splashscreen( 'c:\\VirtualWorlds\\Icons\\SplashScreen.jpg' ) 
viz.go()
PubClasses.myNavigation = PubClasses.freeNavigation() #here, no free navigation
myOneParameterEquation = OneParameterEquation()
myOneParameterEquation.load()

