import viz
import time
import vizinfo
import win32api
import win32con
import pythoncom

import math

from ctypes import windll

wm_pX = 0
wm_pY = 0

FactorA = 1.0 / 1680.0
FactorB = 1.0 / 1050.0

viz.go()

info = vizinfo.add('')
info.translate( .5, .5)
info.title("Menu")
info.drag(viz.ON)

mess1 = vizinfo.add("")
mess2 = vizinfo.add("")
mess3 = vizinfo.add("")
mess1.translate(0.5, 0.9)
mess2.translate(0.5, 0.8)
mess2.translate(0.5, 0.7)
mess1.title("Mouse")
mess2.title("Wiimote")
mess2.title("compute")

#Add radio buttons
red 	= info.add(viz.RADIO, 0, 'Black')
white 	= info.add(viz.RADIO, 0, 'White')
blue 	= info.add(viz.RADIO, 0, 'Blue')

# Add a crosshair
ch = viz.add('crosshair.png')
crosshair = viz.addTexQuad(viz.SCREEN)
crosshair.translate(0.5, 0.5)
crosshair.texture(ch)
crosshair.visible(viz.ON)

# Adding Wiimote
wii = viz.add('wiimote.dle')
wiimote = wii.addWiimote()

def onButtonUp(e):
	global wm_pX
	global wm_pY
	
	win32api.mouse_event(win32con.MOUSEEVENTF_LEFTUP, int(wm_pX * 65535), int((1-wm_pY) * 65535), 0)
	print "up"
	
def onButtonDown(e):
	global wm_pX
	global wm_pY
	
	win32api.mouse_event(win32con.MOUSEEVENTF_LEFTDOWN, int(wm_pX * 65535), int(65535 * (1-wm_pY)), 0)
	print "down"
	
def onTimer(num):
	global wm_pX
	global wm_pY
	
	global mess1
	global mess2
	global mess3
	global crosshair
	
	if num == 0:
		wm_pX = wiimote.posIR[0]
		wm_pY = wiimote.posIR[1]
		
		crosshair.setPosition(wm_pX, wm_pY)
		win32api.mouse_event(win32con.MOUSEEVENTF_ABSOLUTE, int(wm_pX * 65535), int(65535 * (1-wm_pY)), 0)
		
	if num == 1:
		mess1.message(str(wm_pX)+" "+str(wm_pY))
		mess2.message(str(wm_pX * 65535)+" "+str(65535 * (1-wm_pY)))
	
	if num == 2:
		pass
				
viz.callback(viz.TIMER_EVENT,onTimer)
viz.starttimer(0, 0.01, viz.FOREVER)
viz.starttimer(1, 0.01, viz.FOREVER)
viz.starttimer(2, 0.01, viz.FOREVER)

vizact.onbuttondown( red, viz.clearcolor, viz.BLACK )
vizact.onbuttondown( white, viz.clearcolor, viz.WHITE )
vizact.onbuttondown( blue, viz.clearcolor, viz.BLUE )

#Set callbacks for changing wheelbarrow color with radio buttons
viz.callback(viz.SENSOR_UP_EVENT, onButtonUp) 
viz.callback(viz.SENSOR_DOWN_EVENT, onButtonDown) 

 



