#August 19th, 2008
import viz
import vizinfo	#For info box
import viztask 	#For wait time
import random	#For random.choice(), etc.

viz.go()

#****ADD CHARACTER HERE****
#Character M-0327
mv_x = 0; mv_y = 1.78; mv_z = -1.0; viz.MainView.setPosition(mv_x,mv_y,mv_z)
mv_euler_x = 180; mv_euler_y = 0; mv_euler_z = 0; viz.MainView.setEuler(mv_euler_x,mv_euler_y,mv_euler_z)
character1 = viz.add('male.cfg'); character1.translate(0,0,-1.4572); character1.rotate(0,1,0,0); character1.state(1) #Neutral state of avatar 
face1 = character1.face('M-0327.vzf')	#add a face to the avatar
eyes_center = viz.add('M-0327_eyes_Center.jpg'); face1.texture(eyes_center); eyes_center.wrap(viz.WRAP_S,viz.REPEAT); eyes_center.wrap(viz.WRAP_T,viz.REPEAT)
#****ADD CHARACTER HERE****
view1 = viz.get(viz.MAIN_VIEWPOINT)

#Make the avatars' eyes Blink at slightly different rates*****************
#MUST ADD LITERATURE REFERENCES FOR DURATION BETWEEN BLINKS, DURATION OF CLOSE, & DURATION OF OPEN
close_eye = vizact.morph("blink",1,0.1)		#Closing Blink morph, take 0.1sec. to close
open_eye = vizact.morph("blink",0,0.2) 		#Opening Blink morph, take 0.2sec. to open
wait_blink = vizact.waittime(vizact.randfloat(4,10)) 	#Wait 4-10sec. between blinks, less duration for easier tasks (talking), more duration (up to 15sec.) for more difficult tasks
blinkAction = vizact.sequence(wait_blink, close_eye, open_eye, viz.FOREVER) #Blink indefinitely

#Add blink action to face; different avatars will have a slightly different blink rate
face1.addAction(blinkAction, pool=12) 

#Use 4 positions (Left, Right, Center, and Up) to create different Eye Contact 
#l_eyes = viz.add('M-0327_eyes_Left.jpg') 		#modified face, 'eyes' to Left
#r_eyes = viz.add('M-0327_eyes_Right.jpg') 		#modified face, 'eyes' to Right 
#c_eyes = viz.add('M-0327_eyes_Center.jpg') 	#modified face, 'eyes' Center (default)
l_eyes = viz.addTexture('M-0327_eyes_Left.jpg') 	#modified face, 'eyes' to Left
r_eyes = viz.addTexture('M-0327_eyes_Right.jpg') 	#modified face, 'eyes' to Right 
c_eyes = viz.addTexture('M-0327_eyes_Center.jpg') 	#modified face, 'eyes' Center (default)

#TRYING TO DEFINE A SEQUENCE THAT RANDOMLY CHANGES THE TEXTURE ON THE AVATAR'S FACE
#Intention: Make a Sequence that Waits 2-6sec., Randomly changes gaze, Repeats

#Applies a texture for first assignment of "position"
gaze_duration = vizact.waittime(vizact.randint(2,6)) #Mean of gaze duration is 4sec., Wait 2-6sec. between changes in gaze
position = random.choice([l_eyes, r_eyes, c_eyes])  
GazeAction = vizact.sequence(gaze_duration, face1.texture(position), position.wrap(viz.WRAP_S,viz.REPEAT), position.wrap(viz.WRAP_T,viz.REPEAT), viz.FOREVER) #Change gaze indefinitely

#Under "Dynamic Parameters" in Vizard Help, found the following suggestions
#Applies a texture for first assignment of "position"
#gaze_duration = vizact.waittime(vizact.randint(2,6)) #Mean of gaze duration is 4sec., Wait 2-6sec. between changes in gaze
#position = random.choice([l_eyes, r_eyes, c_eyes]) 
#ApplyTexture = vizact.texture_node(position)
#GazeAction = vizact.sequence(gaze_duration, ApplyTexture, position.wrap(viz.WRAP_S,viz.REPEAT), position.wrap(viz.WRAP_T,viz.REPEAT), viz.FOREVER) #Change gaze indefinitely

#Applies a black texture, need REPEAT in GazeAction 
#gaze_duration = vizact.waittime(vizact.randint(2,6)) #Mean of gaze duration is 4sec., Wait 2-6sec. between changes in gaze
#textures = [l_eyes, r_eyes, c_eyes]
#ApplyTexture = vizact.texture_node(vizact.choice(textures,vizact.RANDOM))
#GazeAction = vizact.sequence(gaze_duration, ApplyTexture, viz.FOREVER) #Change gaze indefinitely

#Also tried following code in different combinations with no success
#position = random.choice([l_eyes, r_eyes, c_eyes])  
#print position
#position = vizact.choice([l_eyes, r_eyes, c_eyes],vizact.RANDOM)
#position = vizact.choice(["l_eyes", "r_eyes", "c_eyes"],vizact.RANDOM)
#viz.getOption(position, default="l_eyes")
#GazeAction = vizact.sequence(gaze_duration, position = random.choice([l_eyes, r_eyes, c_eyes]), face1.texture(position), position.wrap(viz.WRAP_S,viz.REPEAT), position.wrap(viz.WRAP_T,viz.REPEAT), viz.FOREVER) #Change gaze indefinitely
#GazeAction = vizact.sequence(gaze_duration, face1.texture(position), viz.FOREVER) #Change gaze indefinitely
#textures = ["M-0327_eyes_Left.jpg", "M-0327_eyes_Right.jpg", "M-0327_eyes_Center.jpg", "M-0327_eyes_Up.jpg"]
#textures = [l_eyes, r_eyes, c_eyes]
#position = vizact.choice(textures,vizact.RANDOM)
#ApplyTexture = vizact.texture_node(vizact.choice(textures,vizact.RANDOM))
#gaze_duration = vizact.waittime(vizact.randint(2,6)) #Mean of gaze duration is 4sec., Wait 2-6sec. between changes in gaze
#GazeAction = vizact.sequence(gaze_duration, ApplyTexture, viz.FOREVER) #Change gaze indefinitely
#GazeAction = vizact.sequence(gaze_duration, ApplyTexture, position.wrap(viz.WRAP_S,viz.REPEAT), position.wrap(viz.WRAP_T,viz.REPEAT), viz.FOREVER) #Change gaze indefinitely
#position = random.choice([l_eyes, r_eyes, c_eyes]) 
#textures = [l_eyes, r_eyes, c_eyes]
#position = vizact.choice(textures,vizact.RANDOM)
#position = vizact.choice([l_eyes, r_eyes, c_eyes],vizact.RANDOM)
#ApplyTexture = vizact.texture_node(position)
#GazeAction = vizact.sequence(gaze_duration, ApplyTexture, viz.FOREVER) #Change gaze indefinitely
#GazeAction = vizact.sequence(gaze_duration, ApplyTexture, position.wrap(viz.WRAP_S,viz.REPEAT), position.wrap(viz.WRAP_T,viz.REPEAT), viz.FOREVER) #Change gaze indefinitely
#TRYING TO DEFINE A SEQUENCE THAT RANDOMLY CHANGES THE TEXTURE ON THE AVATAR'S FACE

#Add Avatar speech Actions with .wav files********************************
Story = vizact.speak("00Demo1_My_grandpa's_snoring_Story.wav", scale=0.01, sync=True)	
length_story_sec = (71)	#Number of seconds in Story .wav file (66) plus 5 seconds
#vizact.speak(filename, scale=1.0, morph='mouth_open', threshold)


def changeEyesDuringStory():	#Automatically loop through direction of gazes
	#Set variables
	count = 0
	pool_number = 3
	
	while count <3:
		face1.addAction(blinkAction, pool=12)
		face1.addAction(GazeAction, pool=10)
		
		yield viztask.waitTime(2)		#Wait 2 seconds, v3.0+
		
		character1.addAction(Story, pool=pool_number); 
		yield viztask.waitTime(length_story_sec)		#Wait seconds; based individually on length of story
			
		#***Story Question***
		QuestionBox = vizinfo.add("")		#Add the vizinfo object
		QuestionBox.translate(1.0,.90) 		#Set position on screen, down lower for longer title
		QuestionBox.title("Who's snoring \nkept me awake?")
		invisibleRadio = QuestionBox.add(viz.RADIO, 0, "")	#Create an invisible Radio button to be the default selected one, so that one of the visible ones must be chosen by the user
		invisibleRadio.visible(0) #invisible
		aRadio = QuestionBox.add(viz.RADIO, 0, "A.  My nephew's snoring")
		bRadio = QuestionBox.add(viz.RADIO, 0, "B.  My grandpa's snoring")	#want a button or box that will be empty at first but can have only one selected when the OK button is pressed	
		cRadio = QuestionBox.add(viz.RADIO, 0, "C.  My father's snoring") 	#not using checkboxes because a user can check more than one
		
		OKbutton = QuestionBox.add(viz.BUTTON, "OK")		#Create a button
		
	count +=1 
	
#Schedule task to start changing eye gaze around while telling story
viztask.schedule(changeEyesDuringStory())