from viz import *

go(FULLSCREEN)

#pos = add('vizppt.dls')
#ori = add('intersense.dls')
#tracker()

g = add('gallery.ive')

# dirty mirror surface
scr =  addTexQuad()
scr.translate(2.75,1.785,-.7)
scr.texture(add('abalone.jpg'))
scr.rotate(90,0,0)
scr.scale(.53,.65,1)
scr.alpha(.1)

frame = add('frame.wrl')
frame.translate(2.8,1.4,-.7)
frame.rotate(90,0,0)
frame.scale(1.7,3,1)
frame.texture(add('finalwood.jpg'))

lite = addLight()
lite.position(4,2,-1)

man = add('male.cfg')
face = man.face('biohead_eyes.vzf')
l_eye = face.getchild('geom_0')
r_eye = face.getchild('geom_1')
man.state(1)

head = man.getbone('skel_Head')
head.lock()

# Keep avatar behind viewer
link = viz.link(viz.MainView,man)
link.preTrans([0,-1.8,-.2])

def addMirror(mirror,mat=None):

	#If mirror matrix is not specifed, get matrix of mirror object
	if mat is None:
		mat = mirror.getMatrix()
		
	#Position of mirror
	pos = viz.Vector(mat.getPosition())
	
	#Direction mirror is pointing
	dir = viz.Vector(mat.getForward())
	dir.normalize()

	#Quaternion rotation of mirror
	quat = mat.getQuat()
	
	#Create render texture
	tex = viz.addRenderTexture()
	
	#Create render node for rendering reflection
	lens = viz.addRenderNode(size=[1024,1024])
	lens.attachTexture(tex)
	lens.setInheritView(True,viz.POST_MULT)
	lens.disable(viz.CULL_FACE,op=viz.OP_SET_OVERRIDE)

	#Setup reflection matrix
	rot = viz.Matrix.quat(quat)
	invRot = rot.inverse()
	lens.setMatrix(viz.Matrix.translate(pos*-1.0)*invRot*viz.Matrix.scale(1,1,-1)*rot*viz.Matrix.translate(pos))
		
	#Setup reflection clip plane
	plane = vizmat.Plane(pos=pos,normal=dir)
	dist = plane.distance([0,0,0])
	lens.clipPlane([-dir[0],-dir[1],-dir[2],dist+0.001])

	#Project reflection texture onto mirror
	mirror.texture(tex)
	mirror.texGen(viz.TEXGEN_PROJECT_EYE)

eyeheight(1.82)

mirrorsurface = viz.addTexQuad()
mirrorsurface.scale(.6,.7,1)
mirrorsurface.setPosition([2.77, 1.8, -.7])
mirrorsurfacerotation = [90,0,0] #rotation around the Z,Y,X axes
mirrorsurface.rotate(mirrorsurfacerotation) 
m = viz.Matrix()
m.setPosition(mirrorsurface.getPosition(viz.ABS_GLOBAL))
m.setEuler(mirrorsurfacerotation[0]-180,-mirrorsurfacerotation[1], mirrorsurfacerotation[2]) #Z,X,Y

#Apply mirror settings to mirror object
addMirror(mirrorsurface,m)

pos = get(HEAD_POS)
oldpos = pos
ps = [10,0,0]
sz = 0.005
xx = 0
yy = 0
zz = 0

def mytimer(num):
	global oldpos,sz,ps,xx,zz,yy
	
	pos = get(HEAD_POS)
	if pos[0] > oldpos[0]-sz and pos[0] < oldpos[0]+sz:
		if pos[1] > oldpos[1]-sz and pos[1] < oldpos[1]+sz:
			if pos[2] > oldpos[2]-sz and pos[2] < oldpos[2]+sz:
				man.state(1)
	else:
		man.state(2)
	oldpos = pos
	p = man.get(POSITION)
	
	ori = get(HEAD_ORI)
	head.rotate(ori[2],ori[0]-90,ori[1]-10)

	l_eye.rotate(-ori[0]*2.5+45,ori[1]*3-10,0)
	r_eye.rotate(-ori[0]*2.5+45,ori[1]*3-10,0)

r_eye.translate(0,0,.007)
l_eye.translate(0,0,.007)

callback(TIMER_EVENT,mytimer)
starttimer(0,0.001,FOREVER)

translate(HEAD_POS,2,0,-.8)
rotate(HEAD_ORI,90,0,0)
