
import viz
viz.phys.enable()
viz.go()

theview = viz.get(viz.MAIN_VIEWPOINT)
theview.translate(0,1.4,0)
greenwall = viz.add('greenwall.osg')
blueglass = viz.add('blueglass.osg')
ball = viz.add('ball.wrl')
ball.setScale(0.1,0.1,0.1)
ball_Link = viz.link(theview,ball)
ball_Link.preTrans([0,0,2])

greenwall.collideMesh()
greenwall.disable(viz.DYNAMICS)
greenwall.enable(viz.COLLIDE_NOTIFY)
ball.collideMesh()
ball.disable(viz.DYNAMICS)
ball.enable(viz.COLLIDE_NOTIFY)
blueglass.collideMesh()
blueglass.disable(viz.DYNAMICS)
blueglass.enable(viz.COLLIDE_NOTIFY)

MOVE_SPEED = 5
TURN_SPEED = 70

def onCollideBegin(e):
	if e.obj1 == ball and e.obj2 == greenwall:
		print 'ball has hit greenwall'
	if e.obj1 == ball and e.obj2 == blueglass:
		print 'ball has hit blueglass'

def mytimer(num):
	if viz.iskeydown(viz.KEY_UP):
		theview.move(0,0,MOVE_SPEED*viz.elapsed(),viz.BODY_ORI)
	elif viz.iskeydown(viz.KEY_DOWN):
		theview.move(0,0,-MOVE_SPEED*viz.elapsed(),viz.BODY_ORI)
	if viz.iskeydown(viz.KEY_RIGHT):
		theview.rotate(0,1,0,TURN_SPEED*viz.elapsed(),viz.BODY_ORI,viz.RELATIVE_WORLD)
	elif viz.iskeydown(viz.KEY_LEFT):
		theview.rotate(0,1,0,-TURN_SPEED*viz.elapsed(),viz.BODY_ORI,viz.RELATIVE_WORLD)

viz.callback(viz.TIMER_EVENT,mytimer)
viz.starttimer(0,0.01,viz.FOREVER)
viz.callback(viz.COLLIDE_BEGIN_EVENT,onCollideBegin)
viz.clearcolor(viz.WHITE)








