import viz

viz.go()

truck = viz.add('Truck01.osg')
truck.setScale(0.001,0.001,0.001)

myLight = viz.addLight()
myLight.setEuler( 90, 0 ,0)


normal_tex = viz.add('mybodynormalsmap.jpg')
truck.texture(normal_tex,unit=1)

shader = viz.addShader(vert='shaders/bump_normal.vert',frag='shaders/bump_normal.frag',flag=viz.SHADER_TANGENT)

ColorMap = viz.addUniformInt('colorMap',0)
NormalMap = viz.addUniformInt('normalMap',1)

truck.apply(shader)
truck.apply(ColorMap)
truck.apply(NormalMap)

#Blue skies ahead
viz.clearcolor(0.7,0.6,1) 


import vizcam
cam = vizcam.PivotNavigate(distance=7.5)
cam.centerNode(truck)