import viz
viz.go()

viz.MainView.getHeadLight().disable()

ball = viz.add('basketball.osg')
ball.translate(0,1.5,3)
ball.rotate(0,1,0,90)
ball.color(viz.WHITE)
ball.ambient(viz.WHITE)
ball.specular(0.6,0.6,0.6)
ball.shininess(40)

normal_tex = viz.add('bball_normal.jpg')
ball.texture(normal_tex,unit=1)

light = viz.add(viz.LIGHT)
light.color(viz.WHITE)
light.ambient(0.2,0.2,0.2)
light.specular(viz.WHITE)
light.translate(0,1.5,2.8)
light.position(0,0,0,1)

quad = light.add(viz.TEXQUAD)
quad.scale(0.02,0.02,0.02)
quad.blendFunc(viz.GL_SRC_ALPHA,viz.GL_ONE)
quad.texture(viz.add('flare19.jpg'))
quad.enable(viz.BLEND)
quad.billboard()

LIGHT_SPEED = 0.25
vizact.whilekeydown(viz.KEY_UP,light.translate,0,vizact.elapsed(LIGHT_SPEED),0,viz.RELATIVE_WORLD)
vizact.whilekeydown(viz.KEY_DOWN,light.translate,0,vizact.elapsed(-LIGHT_SPEED),0,viz.RELATIVE_WORLD)
vizact.whilekeydown(viz.KEY_RIGHT,light.translate,vizact.elapsed(LIGHT_SPEED),0,0,viz.RELATIVE_WORLD)
vizact.whilekeydown(viz.KEY_LEFT,light.translate,vizact.elapsed(-LIGHT_SPEED),0,0,viz.RELATIVE_WORLD)

shader = viz.addShader(vert='shaders/bump_normal.vert',frag='shaders/bump_normal.frag',flag=viz.SHADER_TANGENT)

ColorMap = viz.addUniformInt('colorMap',0)
NormalMap = viz.addUniformInt('normalMap',1)

ball.apply(shader)
ball.apply(ColorMap)
ball.apply(NormalMap)

import vizcam
cam = vizcam.PivotNavigate(distance=0.5)
cam.centerNode(ball)
