varying vec3 lightVec;
varying vec3 eyeVec;
varying vec2 texCoord;
uniform sampler2D colorMap;
uniform sampler2D normalMap;

#define LightNum 1
#define invRadius 2.0

void main (void)
{
	float distSqr = dot(lightVec, lightVec);
	float att = clamp(1.0 -  invRadius * sqrt(distSqr), 0.0, 1.0);
	vec3 lVec = lightVec * inversesqrt(distSqr);

	vec3 vVec = normalize(eyeVec);
	
	vec4 base = texture2D(colorMap, texCoord);
	
	vec3 bump = normalize( texture2D(normalMap, texCoord).xyz * 2.0 - 1.0);

	float diffuse = max( dot(lVec, bump), 0.0 );

	vec4 vDiffuse = gl_LightSource[LightNum].diffuse * gl_FrontMaterial.diffuse * 
					diffuse;	

	vec4 vAmbient = gl_LightSource[LightNum].ambient * gl_FrontMaterial.ambient;

	float specular = 0.0;
	if(diffuse > 0.0) {
		specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0), gl_FrontMaterial.shininess );
	}
	
	vec4 vSpecular = gl_LightSource[LightNum].specular * gl_FrontMaterial.specular * 
					 specular;	

	gl_FragColor = ( vAmbient*base + 
					 vDiffuse*base + 
					 vSpecular) * att;
}
