varying vec3 lightVec;
varying vec3 eyeVec;
varying vec2 texCoord;
uniform sampler2D colorMap;
uniform sampler2D normalMap;
uniform sampler2D heightMap;

#define LightNum 1

void main (void)
{
	float distSqr = dot(lightVec, lightVec);
	float att = clamp(1.0 -  gl_LightSource[LightNum].quadraticAttenuation * sqrt(distSqr), 0.0, 1.0);
	vec3 lVec = lightVec * inversesqrt(distSqr);
	vec3 vVec = normalize(eyeVec);

	// Calculate offset, scale & biais
	float height = texture2D(heightMap, texCoord).x ;
	vec2 newTexCoord = texCoord + ((height * 0.02 - 0.01) * (vVec.xy));

	vec4 base = texture2D(colorMap, newTexCoord);
	vec3 bump = normalize( texture2D(normalMap, newTexCoord).xyz * 2.0 - 1.0);

	float diffuse = max( dot(lVec, bump), 0.0 );
	
	float specular = pow(clamp(dot(reflect(-lVec, bump), vVec), 0.0, 1.0), gl_FrontMaterial.shininess );

	vec4 vAmbient = gl_LightSource[LightNum].ambient * gl_FrontMaterial.ambient;
	vec4 vDiffuse = gl_LightSource[LightNum].diffuse * gl_FrontMaterial.diffuse * diffuse;	
	vec4 vSpecular = gl_LightSource[LightNum].specular * gl_FrontMaterial.specular *specular;	

	vec4 finalColor = (vAmbient*base + vDiffuse*base + vSpecular);
	gl_FragColor = finalColor * att;
	gl_FragColor.a = finalColor.a;
}

