import viz
viz.go()

viz.clearcolor(viz.GRAY)

model = viz.add(viz.TEXQUAD)
model.color(viz.WHITE)
model.ambient(viz.WHITE)
model.specular(viz.WHITE)
model.shininess(90)

model.texture(viz.add('rockwall_color.dds'))
model.texture(viz.add('rockwall_normal.png'),unit=1)
model.texture(viz.add('rockwall_height.png'),unit=2)

shader = viz.addShader(vert='parallax.vert',frag='parallax.frag',flag=viz.SHADER_TANGENT)
model.apply(shader)
model.apply(viz.addUniformInt('colorMap',0))
model.apply(viz.addUniformInt('normalMap',1))
model.apply(viz.addUniformInt('heightMap',2))

model.translate(0,1.8,2)

light = viz.add(viz.LIGHT)
light.color(viz.WHITE)
light.ambient(0.1,0.1,0.1)
light.specular(0.5,0.8,1)
light.translate(0,1.8,1.8)
light.position(0,0,0,1)
light.quadraticattenuation(0.8)

quad = light.add(viz.TEXQUAD)
quad.scale(0.1,0.1,0.1)
quad.blendFunc(viz.GL_SRC_ALPHA,viz.GL_ONE)
quad.texture(viz.add('flare19.jpg'))
quad.enable(viz.BLEND)
quad.billboard()

LIGHT_SPEED = 1.0
vizact.whilekeydown(viz.KEY_UP,light.translate,0,vizact.elapsed(LIGHT_SPEED),0,viz.RELATIVE_WORLD)
vizact.whilekeydown(viz.KEY_DOWN,light.translate,0,vizact.elapsed(-LIGHT_SPEED),0,viz.RELATIVE_WORLD)
vizact.whilekeydown(viz.KEY_RIGHT,light.translate,vizact.elapsed(LIGHT_SPEED),0,0,viz.RELATIVE_WORLD)
vizact.whilekeydown(viz.KEY_LEFT,light.translate,vizact.elapsed(-LIGHT_SPEED),0,0,viz.RELATIVE_WORLD)

import vizcam
cam = vizcam.PivotNavigate()
cam.centerNode(model)