import viz
viz.go()

#Add a background environment
env = viz.add(viz.ENVIRONMENT_MAP,'sky.jpg')
sky = viz.add('skydome.dlc')
sky.texture(env)

#Add a room model
room = viz.add('gallery.ive')
room.enable(viz.BLEND) #Need to enable blending for transparency to work

#Add alpha map. Grayscale image where black is transparent and white is opaque.
alphaMap = viz.add('alphaMap.jpg')

#Add a projector for projecting alpha map onto romm
import projector
proj = projector.add(alphaMap)
proj.affect(room)

#Link the projector to the main viewpoint
viz.link(viz.MainView,proj)

#Create alpha map shader
alphaShader = """
uniform sampler2D texImage;
uniform samplerCube texAlpha;
void main (void)
{
	vec4 color = texture2D(texImage,gl_TexCoord[0].xy);
	color.a *= textureCube(texAlpha,gl_TexCoord[1].xyz).r;
	gl_FragColor = color;
}
"""
shader = viz.addShader( frag = alphaShader )

#Apply shader to room
room.apply(shader)
room.apply(viz.addUniformInt('texImage',0))
room.apply(viz.addUniformInt('texAlpha',1))
