#==============================================================================
# WORLDVIZ 2006
#
# This script loads the orginal image and breaks it into square sized tiles 
# that match the maximal texture size limitations of the host graphics adapter.
# The 'FILENAME' must be manually set to image file (it should be copied into
# the same folder as these scripts.
# The 'TEX_SIZE' must be manually set. Most high-end graphics cards can 
# handle 2048. Keep this number a power of 2 because it avoids a rescaling 
# operating that can lead to extra memory usage and slower load time.
#
# This script uses the PIL (Python Imaging Libary) which must first be installed
# per instructions.
#
#==============================================================================
#import viz
#viz.go()

FILENAME = viz.input('What file to tile?')		# File name of original (big) image
print 'File name is',FILENAME
choices = ['4096','2048','1024']
size_choice = viz.choose('Choose the Tile Size:', choices)   # Chopped texture size
#print 'size choice ',size_choice
#print 'choice', int
TEX_SIZE = int(choices[size_choice])
#==============================================================================
import Image

im = Image.open(FILENAME)

dim = im.size
print dim

# Calculate number of tiles
hTiles = int(dim[0] / TEX_SIZE)
vTiles = int(dim[1] / TEX_SIZE)

# Create hTiles x vTiles cropped sub-images and save to disk
counter = 0
for v in range(0, vTiles):
	for h in range(0, hTiles):
		region = (h*TEX_SIZE, v*TEX_SIZE, (h+1)*TEX_SIZE, (v+1)*TEX_SIZE)
		
		counter += 1
		crop = im.crop(region)
		fileName = FILENAME[:len(FILENAME) - 4] + '_%02d' % counter + '.jpg'
		
		crop.save(fileName)
		print fileName + ' of %d' % (hTiles * vTiles)


del im
print 'All done.'

