#==============================================================================
# WORLDVIZ 2006
#
# This script loads in a tiled image (use choptiles to create the tiles).
# The 'TEX_SIZE' must be manually set to that used in maketiles and
# the 'DIMENSION' must be set to equal the original photo's pixel dimensions.
#
#==============================================================================

TEX_SIZE = 2048					# Chopped texture size

DIMENSION = [50000, 6000]		# Horizontal , vertical pixel dimensions
								# of original full size image

#==============================================================================


import viz
#viz.displaymode(1280,1024)
viz.go()
#viz.windowsize(1280,1024)
# Calculate number of tiles
hTiles = int(DIMENSION[0] / TEX_SIZE) + 1
vTiles = int(DIMENSION[1] / TEX_SIZE) + 1

def onIncomingMail( sentString ):
	print sentString
	sentString = sentString[:len(sentString)-4]
#	viz.clearcache()	
	# Create hTiles x vTiles and apply textures
	counter = 1
	for v in range(0, vTiles):
		for h in range(0, hTiles):
			
			quad = viz.add(viz.TEXQUAD)
			quad.translate(h-hTiles/2.0, -(v-vTiles/2.0), 4.0) 
			
			counter += 1

			fileName = sentString + '_%02d' % counter + '.jpg'
			print fileName
			texture = viz.add(fileName,wrap=viz.CLAMP_TO_EDGE,filter=viz.LINEAR)
			quad.texture(texture)
			texture.remove()

viz.callback(viz.MAIL_EVENT, onIncomingMail)

# Apply a zoom by moving the viewpoint in or out
def onmousewheelmove(x):
	viz.move(0,0,.1*x)

viz.callback(viz.MOUSEWHEEL_EVENT, onmousewheelmove)
viz.mousedata(viz.RELATIVE,viz.RELATIVE)

# Pan the image by moving viewpoint up/down or sideways
def onmousebuttondown():
	pos = viz.mousepos()
	viz.move((pos[0]-.5)/3, (pos[1]-.5)/3, 0)

vizact.whilemousedown(viz.MOUSEBUTTON_MIDDLE, onmousebuttondown)


# Turn off normal mouse walk-thru navigation
viz.mouse(viz.OFF)

viz.eyeheight(0.0)
viz.clearcolor(.1, .1, .1)

viz.clip(.05, 20)

viz.MainScene.hint(viz.FREE_TEXTURE_MEMORY_HINT)