#include <osg/Texture>
#include <osg/Image>

#define MAX_IMAGEGEN_NAME		32
#define MAX_IMAGEGEN_MESSAGE	100
#define MAX_IMAGEGEN_DATA		3
typedef void (IMAGEGEN_PROC)(void *);

typedef struct VizImageGenObj {
	char	name[MAX_IMAGEGEN_NAME];
	char	version[MAX_IMAGEGEN_NAME];
	char	status;
	short	user[MAX_IMAGEGEN_DATA];
	int		command;
	char	mesg[MAX_IMAGEGEN_MESSAGE];
	float	x, y, z, w;
	float	*data;
	int		dataSize;

	osg::ref_ptr<osg::Texture>		texture;
	osg::ref_ptr<osg::Image>		image;

	IMAGEGEN_PROC		*initProc;
	IMAGEGEN_PROC		*updateProc;
	IMAGEGEN_PROC		*commandProc;
	IMAGEGEN_PROC		*closeProc;

} VizImageGenObj;