#code influced by Conrad Parker at
#http://www.vergenet.net/~conrad/boids/pseudocode.html

import viz
import vizmat
import time
import random
import math

viz.phys.enable()
viz.phys.setGravity(0,0,0)


class Flock(viz.EventClass):
	
	
	MOVE_TO_CENTER_STRENGHT = 0.1
	DISTANCE_THRESHOLD = 1.3
	MATCH_VELOCITY_STRENGTH = 1.2
	MAX_SPEED = 10

	HOMING_POINT_STRENGTH = .2
	AVOID_POINT_THRESHHOLD = 7
	BOUNDERY_STRENGTH = 20

	
#Stable schooling
#	MOVE_TO_CENTER_STRENGHT = 0.1
#	DISTANCE_THRESHOLD = .1
#	MATCH_VELOCITY_STRENGTH = 1
#	MAX_SPEED = 10

#	HOMING_POINT_STRENGTH = .2
#	AVOID_POINT_THRESHHOLD = 1
#	BOUNDERY_STRENGTH = 1

	
	BOIDS_UPDATED_EVERY_FRAME = 1
	ORIENT_RATE = .05  #higher makes less filtering
	
	IS_FILTER_ORIENTATION_ON = True
	
	#Timer numbers
	UPDATE_BOIDS = 1
	FILTER_ORIENTATION = 2
	
	def __init__(self, list, boidsUpdateRate = BOIDS_UPDATED_EVERY_FRAME):
		self.boidList = list

		self.counter = .1
		self.boidUpdater = self.updateBoids( min(len(self.boidList),boidsUpdateRate) )
		
		self.homingPoint = None
		self.avoidPoint = None
		self.bounds = None
		
		self.perceptionFactor = 1.0/( len(self.boidList) - 1 )
		
		#Call super class constructor
		viz.EventClass.__init__(self)	
		self.callback( viz.TIMER_EVENT, self.classTimer )
		self.starttimer(self.UPDATE_BOIDS, .01, viz.FOREVER)
		
		self.starttimer(self.FILTER_ORIENTATION, .01, viz.FOREVER)
		
	def moveToCenter(self, theBoid):
		pc = [0,0,0]
		for otherBoid in self.boidList:
			if theBoid != otherBoid:
				otherPos = otherBoid.getPosition()
				pc = [ pc[0]+otherPos[0], pc[1]+otherPos[1], pc[2]+otherPos[2] ]
		
		factor = self.perceptionFactor
		thePos = theBoid.getPosition()
		return [ ((pc[i]*factor)-thePos[i])*self.MOVE_TO_CENTER_STRENGHT for i in range(3) ]
		
	
	def keepDistance(self, theBoid):
		c = [0,0,0]
		thePos = theBoid.getPosition()
		for otherBoid in self.boidList:
			if theBoid is not otherBoid:
				otherPos = otherBoid.getPosition()
				diffPos = [thePos[0]-otherPos[0],thePos[1]-otherPos[1],thePos[2]-otherPos[2]]
				try:
					if math.sqrt((diffPos[0]*diffPos[0]) + (diffPos[1]*diffPos[1]) + (diffPos[2]*diffPos[2])) < self.DISTANCE_THRESHOLD:
						c = [diffPos[0]-c[0],diffPos[1]-c[1],diffPos[2]-c[2]]
				except ValueError:
					print diffPos
					self.resetBoid(theBoid)
					print 'math domain error, keepDistance'
					return [0,0,0]
		return c
		

	def matchVelocity(self, theBoid):
		pv = [0,0,0]
		for otherBoid in self.boidList:
			if theBoid != otherBoid:
				oVel = otherBoid.getVelocity()
				pv = [ pv[0]+oVel[0], pv[1]+oVel[1], pv[2]+oVel[2] ]
				
		factor = 1.0/( len(self.boidList) - 1 )
		theVel = theBoid.getVelocity()
		return [ ( (pv[i]*factor) - theVel[i])*self.MATCH_VELOCITY_STRENGTH for i in range(3) ]


	def limitVelocity(self, theBoid):
		vel = vizmat.Vector(theBoid.newVelocity)
		try:				
			if vel.length() > self.MAX_SPEED:
				vel.normalize()
				theBoid.newVelocity = vel * self.MAX_SPEED
				
		except ValueError:
			self.resetBoid(theBoid)
			print 'math error, limitVelocity'

	def tendToPoint(self, theBoid):
		pos = theBoid.getPosition()
		return [ (self.homingPoint[i]-pos[i])*self.HOMING_POINT_STRENGTH for i in range(3) ]
	
		
	def avoidThePoint(self, theBoid):
		c = [0,0,0]
		thePos = theBoid.getPosition()
		otherPos = self.avoidPoint
		diffPos = [thePos[0]-otherPos[0],thePos[1]-otherPos[1],thePos[2]-otherPos[2]]
		try:
			if math.sqrt((diffPos[0]*diffPos[0]) + (diffPos[1]*diffPos[1]) + (diffPos[2]*diffPos[2])) < self.AVOID_POINT_THRESHHOLD:
				c = [diffPos[0]-c[0],diffPos[1]-c[1],diffPos[2]-c[2]]
		except ValueError:
			self.resetBoid(theBoid)
			print 'math domain error, avoidThePoint', diffPos
			return [0,0,0]

		return c
	
	def boundPosition(self, theBoid):
		vel = [0,0,0]
		pos = theBoid.getPosition()
		
		if pos[0] < self.bounds.getXmin():
			vel[0] += self.BOUNDERY_STRENGTH
		elif pos[0] > self.bounds.getXmax():
			vel[0] -= self.BOUNDERY_STRENGTH
		if pos[1] < self.bounds.getYmin():
			vel[1] += self.BOUNDERY_STRENGTH
		elif pos[1] > self.bounds.getYmax():
			vel[1] -= self.BOUNDERY_STRENGTH
		if pos[2] < self.bounds.getZmin():
			vel[2] += self.BOUNDERY_STRENGTH
		elif pos[2] > self.bounds.getZmax():
			vel[2] -= self.BOUNDERY_STRENGTH
		return vel

	def computeNewVelocity(self, boid):
		v1 = self.moveToCenter(boid)
		v2 = self.keepDistance(boid)
		v3 = self.matchVelocity(boid)
		if self.homingPoint is not None:
			v4 = self.tendToPoint(boid)
		else:
			v4 = [0,0,0]
		if self.bounds is not None:
			v5 = self.boundPosition(boid)
		else:
			v5 = [0,0,0]
		if self.avoidPoint is not None:
			v6 = self.avoidThePoint(boid)
		else:
			v6 = [0,0,0]
		newVel = vizmat.Vector(boid.getVelocity()) + v1 + v2 + v3 + v4 + v5 + v6
		boid.newVelocity = newVel
		
		self.limitVelocity(boid)
	
	def reorientBoids(self):
		for boid in self.boidList:
			forPercent = 1-self.ORIENT_RATE
			forward = [x*forPercent for x in boid.getMatrix().getForward()]
			vel = [x*self.ORIENT_RATE for x in boid.getVelocity()]
			target = [forward[0]+vel[0],forward[1]+vel[1],forward[2]+vel[2]]
			currentPos = boid.getPosition()
			targetPOS = [currentPos[0]+target[0],currentPos[1]+target[1],currentPos[2]+target[2]]
			#boid.setEuler(0, 0, 0)
			#boid.setAxisAngle(0,1,0,180,viz.RELATIVE_LOCAL)
			boid.lookat( targetPOS )
			#boid.setEuler(180, 0, 0, viz.RELATIVE_LOCAL)


	def updateBoids(self, numberToProcess ):
		while True:
			for index, boid in enumerate(self.boidList):
				self.computeNewVelocity(boid)
				pos = boid.getPosition()
				if abs(pos[0]) > 1000 or abs(pos[1]) > 1000 or abs(pos[2]) > 1000:
					boid.setPosition(0,0,0)
				if index % numberToProcess == 0:
					yield None
					
			#update all boids together so they move as one
			for boid in self.boidList:
				boid.setVelocity(boid.newVelocity)
				boid.setAngularVelocity([0,0,0])
				if not self.IS_FILTER_ORIENTATION_ON:
					currentPos = boid.getPosition()
					targetPOS = [currentPos[0]+boid.newVelocity[0],currentPos[1]+boid.newVelocity[1],currentPos[2]+boid.newVelocity[2]]
					boid.lookat( targetPOS )
	
	def classTimer(self, num):
		if num == self.UPDATE_BOIDS:
#			self.boidUpdater.next()

			try:
				self.boidUpdater.next()				
			except:
				print 'next call failed'
				self.killtimer(self.UPDATE_BOIDS)

		if num == self.FILTER_ORIENTATION:
			if self.IS_FILTER_ORIENTATION_ON:
				self.reorientBoids()
	
	def setHomingPoint(self, point):	
		self.homingPoint = point
	
	def setAvoidPoint(self, point):
		self.avoidPoint = point
	
	def setBoundingBox(self, boundingBox):
		self.bounds = boundingBox
	
	def resetBoid(self, boid):
		boid.setPosition(random.uniform(0, 20), random.uniform(0, 20), 0)
		boid.setVelocity(0,0,1)
		
	def getBoidList(self):
		return self.boidList
		
	def setBoidList(self, newBoidList):
		self.boidList = newBoidList
		self.perceptionFactor = 1.0/( len(self.boidList) - 1 )
