import viz
import vizact
import Flock

import random

viz.go(viz.FULLSCREEN)
viz.clearcolor(viz.GRAY)
viz.MainView.setPosition(20, 10, -40)
viz.MainView.lookat(0,0,0)

fish = viz.add('wheelbarrow.ive')	
fish.visible(viz.OFF)

def createBoidWheelBarrow():
	boidModel = fish.clone()
	boidModel.setPosition(random.uniform(0,i), random.uniform(0,i), i)
	scale = .7
	boidModel.setScale([scale,scale,scale])
	boidModel.collideSphere( bounce = 0)
	boidModel.newVelocity = 0
	return boidModel

boidList = []
for i in xrange(30):
	boidList.append( createBoidWheelBarrow() )

fishSchool = Flock.Flock(boidList)

boxobj = viz.add('box.wrl')
scale = 20
boxobj.scale(scale,scale,scale)
boxobj.alpha(.1)
bbox = boxobj.getBoundingBox()
fishSchool.setBoundingBox( bbox )

#logo to avoid
logo = viz.add('logo.wrl')
logo.collideBox()
logo.disable(viz.DYNAMICS)

vizact.whilekeydown('w',logo.translate,0,0,vizact.elapsed(5),viz.REL_LOCAL)
vizact.whilekeydown('s',logo.translate,0,0,vizact.elapsed(-5),viz.REL_LOCAL)
vizact.whilekeydown('a',logo.rotate,0,1,0,vizact.elapsed(-90),viz.REL_LOCAL)
vizact.whilekeydown('d',logo.rotate,0,1,0,vizact.elapsed(90),viz.REL_LOCAL)
vizact.whilekeydown(viz.KEY_DOWN,logo.translate,0,vizact.elapsed(-5),0,viz.REL_LOCAL)
vizact.whilekeydown(viz.KEY_UP,logo.translate,0,vizact.elapsed(5),0,viz.REL_LOCAL)

def avoidLogo():
	fishSchool.setAvoidPoint( logo.getPosition(viz.ABS_GLOBAL) )
vizact.ontimer(0, avoidLogo)

behindLogoLink = viz.link(viz.MainView, logo)
behindLogoLink.preTrans(0, 0, 10)
behindLogoLink.disable()

import vizcam
def flyBehindLogo():
	if behindLogoLink.getEnabled():
		behindLogoLink.disable()
		viz.setCameraHandler(None)			
	else:
		behindLogoLink.enable()
		fly = vizcam.FlyNavigate()
		fly.sensitivity(5,.3)
		viz.setCameraHandler(fly)
		
vizact.onkeydown(' ', flyBehindLogo)


#Paramater chaning GUI

import vizinfo
boxInfo = vizinfo.add( 'Flock parameters' )
boxInfo.drag(viz.ON)
boxInfo.translate( .98, .02 )
boxInfo.alignment(vizinfo.LOWER_RIGHT)

centerStrengthText = boxInfo.add( viz.TEXTBOX, 'MOVE_TO_CENTER_STRENGHT' )
distThreshText = boxInfo.add( viz.TEXTBOX, 'DISTANCE_THRESHOLD' )
matchVelText = boxInfo.add( viz.TEXTBOX, 'MATCH_VELOCITY_STRENGTH' )
maxSpeedText = boxInfo.add( viz.TEXTBOX, 'MAX_SPEED' )
avoidPointText = boxInfo.add( viz.TEXTBOX, 'AVOID_POINT_THRESHHOLD' )
numberBoidsText = boxInfo.add( viz.TEXTBOX, 'Number Of boids' )

filterOriCheckBox = boxInfo.add( viz.CHECKBOX, 'IS_FILTER_ORIENTATION_ON' )

applyButton = boxInfo.add( viz.BUTTON, 'Apply' )
applyButton.setScale(2,2,2)

resetButton = boxInfo.add( viz.BUTTON, 'Reset Boids' )

#Initial material settings
centerStrengthText.message( str(fishSchool.MOVE_TO_CENTER_STRENGHT) )
distThreshText.message( str(fishSchool.DISTANCE_THRESHOLD) )
matchVelText.message( str(fishSchool.MATCH_VELOCITY_STRENGTH) )
maxSpeedText.message( str(fishSchool.MAX_SPEED) )
avoidPointText.message( str(fishSchool.AVOID_POINT_THRESHHOLD) )
numberBoidsText.message( str(len(fishSchool.getBoidList())) )

filterOriCheckBox.set( fishSchool.IS_FILTER_ORIENTATION_ON )

def setFlock():
	fishSchool.MOVE_TO_CENTER_STRENGHT = float( centerStrengthText.get() )
	fishSchool.DISTANCE_THRESHOLD = float( distThreshText.get() )
	fishSchool.MATCH_VELOCITY_STRENGTH = float( matchVelText.get() )
	fishSchool.MAX_SPEED = float( maxSpeedText.get() )
	fishSchool.AVOID_POINT_THRESHHOLD = float( avoidPointText.get() )
	
	fishSchool.IS_FILTER_ORIENTATION_ON = bool( filterOriCheckBox.get() )
			
	targetNumberOfBoids = int(numberBoidsText.get())
	boidList = fishSchool.getBoidList()
	if targetNumberOfBoids < len(boidList):
		#subtrack boids
		numberToRemove = len(boidList)-targetNumberOfBoids
		for i in range(numberToRemove):
			boid = boidList.pop()
			boid.remove()
	else:
		#add boids
		numberToAdd = targetNumberOfBoids-len(boidList)
		for i in range(numberToAdd):
			boid = createBoid()
			boidList.append(boid)
			
def onButton():
	setFlock()

vizact.onbuttondown(applyButton,onButton)

def onReset():
	boidList = fishSchool.getBoidList()
	for index, boid in enumerate(boidList):
		boid.setPosition(random.uniform(0,index), random.uniform(0,index), index)
		boid.reset()

vizact.onbuttondown(resetButton,onReset)