import viz
viz.go()
viz.clearcolor(viz.SKYBLUE)
viz.MainView.setPosition([0,0,-3])

viz.phys.enable()

logo = viz.add('logo.wrl', pos=[1,0,0])
logo.collideMesh()
marker = viz.add('marker.wrl', pos=[-1,0,0])
marker.collideMesh()
duck = viz.add('duck.cfg', pos=[0,1,0])
duck.collideMesh()

#Add the object that will do the grabbing
hand = viz.add( 'hand.cfg' )
hand.setScale([3,3,3])
hand.translate( 0, 0, 0 )
hand.collideMesh()

grabLink = None #The handle to the link object

#Grab or let go of the ball
def tryGrab():
	global grabLink
	nodes = viz.phys.intersectNode(hand)
	if len(nodes) > 0: #if list is not empty
		grabLink = viz.grab( hand, nodes[0] )
		
def drop():
	global grabLink
	grabLink.remove()
	grabLink = None

def grabOrDrop():
	if grabLink:
		drop()
	else:
		tryGrab()
		
vizact.onkeydown(' ',grabOrDrop)


#Setup keyboard control of hand
vizact.whilekeydown(viz.KEY_UP,hand.translate,0,vizact.elapsed(1),0,viz.RELATIVE_WORLD)
vizact.whilekeydown(viz.KEY_DOWN,hand.translate,0,vizact.elapsed(-1),0,viz.RELATIVE_WORLD)
vizact.whilekeydown(viz.KEY_RIGHT,hand.translate,vizact.elapsed(1),0,0,viz.RELATIVE_WORLD)
vizact.whilekeydown(viz.KEY_LEFT,hand.translate,vizact.elapsed(-1),0,0,viz.RELATIVE_WORLD)

vizact.whilekeydown('w',hand.rotate,1,0,0,vizact.elapsed(90),viz.RELATIVE_WORLD)
vizact.whilekeydown('s',hand.rotate,1,0,0,vizact.elapsed(-90),viz.RELATIVE_WORLD)
vizact.whilekeydown('d',hand.rotate,0,1,0,vizact.elapsed(90),viz.RELATIVE_WORLD)
vizact.whilekeydown('a',hand.rotate,0,1,0,vizact.elapsed(-90),viz.RELATIVE_WORLD)