import viz
import vizact
class VizSpeakAction(viz.ActionClass):

	def begin(self,object):
		self.avnumbers = self._actiondata_.data[0]
		self.length = self._actiondata_.data[1]
		self.morph = self._actiondata_.data[2]
		self.filename = self._actiondata_.data[3]
		self.scale = self._actiondata_.data[4]
		self.thresh = self._actiondata_.data[5]
		sync = True #self._actiondata_.data[6]
		self.numsamples = len(self.avnumbers)
		self.elapsed = 0
		self.bone = None
		self.audio = None
		self.lastsync = 0
		self.lastAudioTime = -1
		
		if object.getFace():
			if isinstance(self.morph,str):
				self.morph = object.getFace().getMorphID(self.morph)
		else:
			jawBoneName = object.getConfigValue('jaw_bone')
			self.bone = object.getBone(jawBoneName)
			if not self.bone.valid():
				viz.logWarn('** WARNING: Cannot run speech action on avatar, no face or jaw bone was specified')
				self.end(object)
				return
			self.bone.lock()
			
		if self.length <= 0.0:
			self.end(object)
		else:
			if sync:				
				self.audio = viz.addAudio(self.filename)
				self.audio.play()

	def update(self,elapsed,object):

		self.elapsed += elapsed
		self.lastsync += elapsed
		
		#Resync mouth with audio every 5 seconds
		if self.audio and self.lastsync > 5.0:
			audioTime = self.audio.getTime()
			if audioTime > self.lastAudioTime:
				self.lastAudioTime = audioTime
				self.elapsed = audioTime
			self.lastsync = 0.0
			
		p = self.elapsed / self.length
		if p >= 1.0:
			self.end(object)
			return
		
		sample = int(p * self.numsamples)
		value = self.avnumbers[sample]
		
		if value < self.thresh:
			value = 0
		
		if self.bone:
			self.bone.rotate(1,0,0,value*self.scale*10,viz.AVATAR_LOCAL)
		else:
			object.getFace().morph(self.morph,value*self.scale)
		
	def end(self,object):
		if not self.finished():
			if self.audio:
				self.audio.stop()
				self.audio.remove()
			if self.bone:
				self.bone.unlock()
			elif object.getFace():
				object.getFace().morph(self.morph,0)
			viz.ActionClass.end(self,object)
			
	def pause(self,state):
		viz.ActionClass.pause(self,state)
		if state:
			self.audio.pause()
		else:
			self.audio.play()
			
			
def __speak_pauseable(filename, scale=1.0, morph='mouth_open', threshold = 0, sync = False):
	import vizwave
	#Get wave data
	avnumbers,length = vizwave.getsamples(filename,400,5)
	
	if len(avnumbers) > 0 and threshold < 0:
		# calculate default threshold, otherwise provided threshold is used
		sum = 0
		for value in avnumbers:
			sum = sum + value
		threshold = sum / len(avnumbers)	# average value of the array
			
	bla = viz.ActionData()
	bla.data = [avnumbers,length,morph,filename,scale,threshold,sync]
	bla.actionclass = VizSpeakAction
	return bla
	

viz.upgradeModule(vizact,'speak_pauseable',__speak_pauseable)