import viz
viz.go()

#Add a model
viz.add('tankmaze.wrl')

#Import blur module
import vizblur

#Enable fullscreen blurring
vizblur.enable()

#Create menu for blur options
import vizmenu
blurMenu = vizmenu.add()
optionMenu = blurMenu.add( 'Options' )

#Slider for adjusting blur scale
blurSlider = optionMenu.add(viz.PROGRESS_BAR,'1.00','Blur Scale:')
blurSlider.set(0.5)

#Checkbox for enabling/disabling blur
blurCheckbox = optionMenu.add(viz.CHECKBOX,'Enabled:')
blurCheckbox.set(1)

#Change blur scale when slider is moved
def onBlurSlider(pos):
	val = pos * 2.0
	vizblur.setScale(val)
	blurSlider.message('%.2f'%(val))
vizact.onslider(blurSlider,onBlurSlider)

#Enable/Disable blurring when checkbox clicked
vizact.onbuttondown(blurCheckbox,vizblur.enable)
vizact.onbuttonup(blurCheckbox,vizblur.disable)