import viz
viz.go()

quad = viz.add(viz.TEXQUAD)
tex1 = viz.add('forest.jpg')
tex2 = viz.add('forest_depth.bmp')
quad.texture(tex1)
quad.texture(tex2,'',1)

quad.translate(0,1.82,1)

fp = viz.add('depthmap.dlm')
quad.modify(fp)

viz.clip(0.1,100)
fp.command(0,'',0.1,100)

ball = viz.add('ball.wrl')
ball.scale(0.1,0.1,0.1)
ball.translate(0,1.82,1)

def ontimer(num):
	if viz.iskeydown(viz.KEY_LEFT):
		ball.translate(-0.5*viz.elapsed(),0,0,viz.RELATIVE)
		ball.rotate(0,0,1,250*viz.elapsed(),viz.RELATIVE_WORLD)
	elif viz.iskeydown(viz.KEY_RIGHT):
		ball.translate(0.5*viz.elapsed(),0,0,viz.RELATIVE)
		ball.rotate(0,0,1,-250*viz.elapsed(),viz.RELATIVE_WORLD)

	if viz.iskeydown(viz.KEY_UP):
		ball.translate(0,0.5*viz.elapsed(),0,viz.RELATIVE)
		ball.rotate(1,0,0,250*viz.elapsed(),viz.RELATIVE_WORLD)
	elif viz.iskeydown(viz.KEY_DOWN):
		ball.translate(0,-0.5*viz.elapsed(),0,viz.RELATIVE)
		ball.rotate(1,0,0,-250*viz.elapsed(),viz.RELATIVE_WORLD)

	if viz.iskeydown(viz.KEY_HOME):
		ball.translate(0,0,0.5*viz.elapsed(),viz.RELATIVE)
	elif viz.iskeydown(viz.KEY_END):
		ball.translate(0,0,-0.5*viz.elapsed(),viz.RELATIVE)

viz.callback(viz.TIMER_EVENT,ontimer)
viz.starttimer(0,0.01,viz.FOREVER)
