import viz

d = viz.Data()
d.scale = 1.0
d.created = False

def enable(width=512,height=512):
	"""Enable fulscreen blurring"""
	if not d.created:
		d.created = True
		d.passes = []
		
		#Size of render passes
		size = [width,height]

		#Uniforms for shaders
		srcImageUniform = viz.addUniformInt('srcImage',0)
		blurScaleUniform = viz.addUniformFloat('blurScale',1.0)

		#Create horizontal blur shader
		shader_source = """
		uniform sampler2D srcImage;
		uniform float blurScale;
		const float BlurOffsets[18] = {%val%};
		void main(void)
		{
			vec4 color = vec4(0,0,0,0);
			for( int i = 0; i < 18; i+=2 ) {
				color += ( texture2D( srcImage, gl_TexCoord[0].xy + vec2( BlurOffsets[i]*blurScale, 0.0 ) ) * BlurOffsets[i + 1] );
			}
			color.a = 1.0;
			gl_FragColor = color / 1.7;
		}"""
		BlurOffsets = [0]*18
		for i in xrange(0,18,2):
			offset = ((i-8.0) / 2.0) * (1.0 / size[0])
			x = (i - 8.0) / 8.0
			weight = 0.05 + ((-(x*x) + 1.0) / 4.0)
			BlurOffsets[i] = str(offset)
			BlurOffsets[i+1] = str(weight)
		shader_source = shader_source.replace('%val%',','.join( BlurOffsets ) )
		horzBlurShader = viz.addShader(frag=shader_source)

		#Create vertical blur shader
		shader_source = """
		uniform sampler2D srcImage;
		uniform float blurScale;
		const float BlurOffsets[18] = {%val%};
		void main(void)
		{
			vec4 color = vec4(0,0,0,0);
			for( int i = 0; i < 18; i+=2 ) {
				color += ( texture2D( srcImage, gl_TexCoord[0].xy + vec2( 0.0, BlurOffsets[i]*blurScale ) ) * BlurOffsets[i + 1] );
			}
			color.a = 1.0;
			gl_FragColor = color / 1.7;
		}"""
		BlurOffsets = [0]*18
		for i in xrange(0,18,2):
			offset = ((i-8.0) / 2.0) * (1.0 / size[1])
			x = (i - 8.0) / 8.0
			weight = 0.05 + ((-(x*x) + 1.0) / 4.0)
			BlurOffsets[i] = str(offset)
			BlurOffsets[i+1] = str(weight)
		shader_source = shader_source.replace('%val%',','.join( BlurOffsets ) )
		vertBlurShader = viz.addShader(frag=shader_source)
		
		for eye in [viz.RENDER_LEFT,viz.RENDER_RIGHT]:
			
			#Render textures for ping-ponging
			tex1 = viz.addRenderTexture()
			tex2 = viz.addRenderTexture()
			
			"""
			Pass 1 renders the normal scene to a texture
			"""
			pass1 = viz.addRenderNode(size=size)
			pass1.attachTexture(tex1)
			pass1.setOrder(viz.PRE_RENDER,-5)
			pass1.disable(eye)
			
			"""
			Pass 2 renders the texture from pass 1 onto a quad.
			The quad has a shader attached which blurs the texture horizontally.
			"""
			pass2 = viz.addRenderNode()
			pass2.setHUD(0,200,0,200,renderQuad=True)
			pass2.setSize(size[0],size[1])
			pass2.setBuffer(viz.RENDER_FBO)
			pass2.setOrder(viz.PRE_RENDER,-4)
			pass2.attachTexture(tex2)
			pass2.texture(tex1)
			pass2.apply(horzBlurShader)
			pass2.apply(srcImageUniform)
			pass2.apply(blurScaleUniform)
			pass2.disable(eye)
			
			"""
			Pass 3 renders the texture from pass 2 onto a quad.
			The quad has a shader attached which blurs the texture vertically.
			"""
			pass3 = viz.addRenderNode()
			pass3.setHUD(0,200,0,200,renderQuad=True)
			pass3.setSize(size[0],size[1])
			pass3.setBuffer(viz.RENDER_FBO)
			pass3.setOrder(viz.PRE_RENDER,-3)
			pass3.attachTexture(tex1)
			pass3.texture(tex2)
			pass3.apply(vertBlurShader)
			pass3.apply(srcImageUniform)
			pass3.apply(blurScaleUniform)
			pass3.disable(eye)
			
			"""
			Pass 4 renders the final blurred texture to the screen
			"""
			pass4 = viz.addRenderNode()
			pass4.setHUD(0,200,0,200,renderQuad=True)
			pass4.setOrder(viz.POST_RENDER,-1)
			pass4.texture(tex1)
			pass4.disable(eye)
			
			#Save render nodes and blur uniform
			d.passes += [pass1,pass2,pass3,pass4]
			
		d.blurUniform = blurScaleUniform
	
	[ p.visible(True) for p in d.passes ]
	viz.MainScene.visible(0,viz.WORLD)
	
def disable():
	"""Disable fullscreen blurring"""
	if d.created:
		[ p.visible(False) for p in d.passes ]
	viz.MainScene.visible(1,viz.WORLD)
	
def setEnabled(val):
	"""Set enabled state of blurring"""
	if val:
		enable()
	else:
		disable()
	
def setScale(val):
	"""Set scale factor for blurring"""
	d.scale = val
	if d.created:
		d.blurUniform.set(val)
	
