"""
Install
1) Place Philips' opengl32.dll in Vizard's bin directory
2) Put the python plugin PhilipsWOW.dll in your script directory or in Vizard's plugin directory

Windows Setup
1) Set mointors to clone mode and set the resolution to the philips screen's native

Script Setup
1) Import PhilipsWOW
2) Call PhilipsWOW.SetApplicationResolution( WIDTH, HEIGHT ) with the window resolution 
   before viz.go()
3) Call viz.go( viz.FULLSCREEN )

IF USING SCREEN OBJECTS: 
When objects are on the Vizard screen or ortho, add this line to the vizcore.cfg file:
viz.clearDepth = 0
or call viz.setOption( 'viz.clearDepth', 0 )
"""

import viz
import PhilipsWOW

WIDTH = 1920
HEIGHT = 1080
PhilipsWOW.SetApplicationResolution( WIDTH, HEIGHT )
viz.go()

#g = viz.add( 'gallery.ive' )
logo = viz.add( 'logo.wrl' )
logo.translate( 0, 1.5, 1.5)
logo.addAction( vizact.spin( 0, 1, 0, 45 ) )

#viz.clip(.2,50)
#viz.MainWindow.frustum(-.05, .05, -.05, .05, .05, 5)
#viz.MainWindow.frustum(-1, 1, -1, 1, 1, 5)


#PhilipsWOW.SetRenderingParameters(  \
#	64,  \ # headerFactor
#	128,  \ # headerOffset
#	0, \ # clear edge horz
#	0, \ # clear edge vert
#	1, \ # visualSmooth \
#	1, \ # inverseProjection \
#	0, \ # zNearInterest
#	1, \ # zFarInterest
#	512 ) #farNearRatio )



def onKeyDown(key):
	if key == ' ':
		PhilipsWOW.SetRenderingParameters(64,128,0,0,True,True,0,1,512)
	if key == 'r':
		print 'reset!!'
		PhilipsWOW.SetRenderingParameters(64,128,0,0,True,True,0.0,1.0,512.0)
		
viz.callback(viz.KEYDOWN_EVENT,onKeyDown)
