"""
Install
1) Place Philips' modivided opengl32.dll in Vizard's bin directory
2) Put the python plugin PhilipsWOW.dll in your script directory or in Vizard's plugin directory

Windows Setup
1) No other monitors besides the Philips display should be enabled

Script Setup
1) Import PhilipsWOW
2) Call PhilipsWOW.SetApplicationResolution( WIDTH, HEIGHT ) with the current windows resolution 
   before viz.go()
3) Call viz.go( viz.FULLSCREEN )

WIDTH = 1920
HEIGHT = 1080
import PhilipsWOW
PhilipsWOW.SetApplicationResolution( WIDTH, HEIGHT )
viz.go(viz.FULLSCREEN )

viz.setOption( 'viz.clearDepth', 0 )

"""

import viz
import PhilipsWOW
import vizinfo

WIDTH = 1920
HEIGHT = 1080

#WIDTH = 800
#HEIGHT = 600

#viz.displaymode( WIDTH, HEIGHT )
#viz.MainWindow.fusionDistance( 1.5 )

#PhilipsWOW.Enable3DMode( 0 )
PhilipsWOW.SetApplicationResolution( WIDTH, HEIGHT )
#PhilipsWOW.SetRenderingParameters(64,128,2,2,True,False,1,1,512.0)
PhilipsWOW.SetInputResolution( WIDTH/2, HEIGHT/2 )

viz.setOption( 'viz.clearDepth', 0 )
#viz.setLogLevel( viz.LOG_INFO )

viz.go( viz.FULLSCREEN )
#viz.go()

#viz.mouse( viz.OFF )

viz.clip(1,10)

viz.add( 'gallery.ive' )

logo = viz.add( 'logo.wrl' )
logo.translate( 0, 1.5, 3)

logo.addAction( vizact.spin( 0, 1, 0, 90 ) )


boxInfo = vizinfo.add( 'Box Material Characteristics' )
boxInfo.translate( .4, .96 )
headerFactorSlider = boxInfo.add( viz.SLIDER, 'headerFactor' )
headerOffsetSlider = boxInfo.add( viz.SLIDER, 'headerOffset' )

#horizClearEdgeRadio0 = boxInfo.add( viz.RADIO, 0, 'Horiz Clear Edge	0' )
#horizClearEdgeRadio1 = boxInfo.add( viz.RADIO, 0, 'Horiz Clear Edge	0' )
#horizClearEdgeRadio2 = boxInfo.add( viz.RADIO, 0, 'Horiz Clear Edge	0' )
#horizClearEdgeRadio3 = boxInfo.add( viz.RADIO, 0, 'Horiz Clear Edge	0' )
#vertClearEdgeRadio0 = boxInfo.add( viz.RADIO, 1, 'Vert Clear Edge	0' )
#vertClearEdgeRadio1 = boxInfo.add( viz.RADIO, 1, 'Vert Clear Edge	1' )
#vertClearEdgeRadio2 = boxInfo.add( viz.RADIO, 1, 'Vert Clear Edge	2' )

visualSmoothButton = boxInfo.add( viz.CHECKBOX, 'Visual Smooth' )
inverseProjectionButton = boxInfo.add( viz.CHECKBOX, 'Use Inverse Projection Matrix' )

zNearInterestSlider = boxInfo.add( viz.SLIDER, 'zNearInterest' )
zFarInterestSlider = boxInfo.add( viz.SLIDER, 'zFarInterest' )
farNearRatioSlider = boxInfo.add( viz.SLIDER, 'farNearRatio' )

enable3DButton = boxInfo.add( viz.CHECKBOX, 'Enable3D' )

#Initial material settings
headerFactorSlider.set( 0.25098039215686274509803921568627 )
headerOffsetSlider.set( .5 )
zNearInterestSlider.set( 0 )
zFarInterestSlider.set( 1 )
farNearRatioSlider.set( 0.015625 )

visualSmoothButton.set( False )
inverseProjectionButton.set( True )

enable3DButton.set( True )


def setDisplay():
	headerFactor = int( headerFactorSlider.get() * 255 )
	headerOffset = int( headerOffsetSlider.get() * 255 )
	
	visualSmooth = visualSmoothButton.get()
	inverseProjection = inverseProjectionButton.get()
	
	zNearInterest = zNearInterestSlider.get()
	zFarInterest = zFarInterestSlider.get()
	farNearRatio = farNearRatioSlider.get() * 32768.0
	
	print PhilipsWOW.SetRenderingParameters( headerFactor, headerOffset, 0, 0, visualSmooth, inverseProjection, zNearInterest, zFarInterest, farNearRatio )
	
	

def sliderEvent( pos ):
	setDisplay()

vizact.onslider( headerFactorSlider, sliderEvent )
vizact.onslider( headerOffsetSlider, sliderEvent )
vizact.onslider( zNearInterestSlider, sliderEvent )
vizact.onslider( zFarInterestSlider, sliderEvent )
vizact.onslider( farNearRatioSlider, sliderEvent )

def buttonEvent( ):
	setDisplay()
	
vizact.onbuttondown( visualSmoothButton, buttonEvent )
vizact.onbuttondown( inverseProjectionButton, buttonEvent )
vizact.onbuttonup( visualSmoothButton, buttonEvent )
vizact.onbuttonup( inverseProjectionButton, buttonEvent )


def change3DMode( isEnbled ):
	PhilipsWOW.Enable3DMode( isEnbled )

vizact.onbuttondown( enable3DButton, change3DMode, True )
vizact.onbuttonup( enable3DButton, change3DMode, False )

#vizact.onbuttondown( horizClearEdgeRadio0, buttonEvent )
#vizact.onbuttonup( horizClearEdgeRadio0, buttonEvent )
#vizact.onbuttondown( horizClearEdgeRadio1, buttonEvent )
#vizact.onbuttonup( horizClearEdgeRadio1, buttonEvent )
#vizact.onbuttondown( horizClearEdgeRadio2, buttonEvent )
#vizact.onbuttonup( horizClearEdgeRadio2, buttonEvent )
#vizact.onbuttondown( horizClearEdgeRadio3, buttonEvent )
#vizact.onbuttonup( horizClearEdgeRadio3, buttonEvent )
#
#vizact.onbuttondown( vertClearEdgeRadio0, buttonEvent )
#vizact.onbuttonup( vertClearEdgeRadio0, buttonEvent )
#vizact.onbuttondown( vertClearEdgeRadio1, buttonEvent )
#vizact.onbuttonup( vertClearEdgeRadio1, buttonEvent )
#vizact.onbuttondown( vertClearEdgeRadio2, buttonEvent )
#vizact.onbuttonup( vertClearEdgeRadio2, buttonEvent )

mouseLink = viz.link( viz.Mouse , viz.add(viz.TEXQUAD,viz.SCREEN,enable=(viz.DEPTH_TEST),texture=viz.add('crosshair.png')) )

#mouseLink.postTrans( -.003, 0, 0 )

#def onTimer(num):
#	#The timer with the id 'num' has expired
#	PhilipsWOW.SignalZBufferAvailable()
#
#viz.callback(viz.TIMER_EVENT,onTimer)
#viz.starttimer( 0, 0, viz.FOREVER )
#

ball = viz.addChild( 'ball.wrl', viz.WORLD, viz.Scene2 )
ball.setPosition( 0, 0, 50 )

currentScene = 0
def onKeyDown(key):
	global currentScene
	if key == ' ': 
		currentScene = (currentScene + 1) % 2
		viz.scene( currentScene + 1 )
	if key == 'r':
		PhilipsWOW.SetRenderingParameters(64,128,0,0,False,True,0.0,1.0,512.0)
		

viz.callback(viz.KEYDOWN_EVENT,onKeyDown)


