import viz
viz.go(viz.FULLSCREEN)

"""
Underwater plugin commands:
	case 0: //Set displacement
			displacement = x;
			break;
		case 1: //Set noise speed
			noise_speed = x;
			break;
		case 2: //Set scale
			noise_scale[0] = noise_scale[1] = x;
			break;
		case 3: //Set tesselation
"""


import vizinfo
info = vizinfo.add('This script demonstrates an underwater effect.\nThe scene is rendered to a texture then applied\nto an animated distorted mesh.')
displacement = info.add(viz.SLIDER,'Displacement:')
speed = info.add(viz.SLIDER,'Speed:')

#Add a model
viz.add('gallery.ive')

#Don't render main scene, since we are rendering to texture
viz.MainScene.visible(0,viz.WORLD)

#Create render texture
rt = viz.addRenderTexture()

#Create render node
lens = viz.addRenderNode(size=viz.window.getSize())
lens.attachTexture(rt)
lens.setOrder(viz.POST_RENDER,-1)

#Add underwater mesh
quad = viz.add('underwater.dlc',parent=viz.SCREEN)
quad.draworder(-1)
quad.disable(viz.LIGHTING)
quad.texture(rt)
quad.scale(100,100)

def onslider(obj,pos):
	if obj == displacement:
		quad.command(0,'',pos)
	elif obj == speed:
		quad.command(1,'',pos*0.5)

viz.callback(viz.SLIDER_EVENT,onslider)

viz.fog(0.2)
viz.fogcolor(0,0,0.5)