from viz import *

go()

drawer = add('water.dlr')
translate(HEAD_POS,4.7,-9.4,16.0)

fog(5,50)
fogcolor(0,.5,.8)

sky = addchild('sky.wrl')
sky.appearance(TEXMIPMAP | DECAL)

fish = add('kelpbass.wrl')
fish.scale(.05,.05,.05) 
fish.translate(4.7,-7.7,17)
fish.rotate(-55,0,0)

ground = addchild('ground.wrl')
ground.scale(5,20,5)
ground.translate(0,-25,0)

caustics = add('caustics.avi')
caustics.wrap(WRAP_S,REPEAT)
caustics.wrap(WRAP_T,REPEAT)
caustics.play()
caustics.loop()

ground.texture(caustics)
texmat = viz.Transform()
texmat.setScale(5,5,1)
ground.texmat(texmat)




import vizinfo
info = vizinfo.add('This script demonstrates an underwater effect.\nThe scene is rendered to a texture then applied\nto an animated distorted mesh.')
displacement = info.add(viz.SLIDER,'Displacement:')
speed = info.add(viz.SLIDER,'Speed:')


#Don't render main scene, since we are rendering to texture
viz.MainScene.visible(0,viz.WORLD)

#Create render texture
rt = viz.addRenderTexture()

#Create render node
lens = viz.addRenderNode(size=viz.window.getSize())
lens.attachTexture(rt)
lens.setOrder(viz.POST_RENDER,-1)

#Add underwater mesh
quad = viz.add('underwater.dlc',parent=viz.SCREEN)
quad.draworder(-1)
quad.disable(viz.LIGHTING)
quad.texture(rt)
quad.scale(100,100)

def onslider(obj,pos):
	if obj == displacement:
		quad.command(0,'',pos)
	elif obj == speed:
		quad.command(1,'',pos*0.5)

viz.callback(viz.SLIDER_EVENT,onslider)

viz.fog(0.05)
viz.fogcolor(0,.5,0.7)
