/***********************************************************************
************************************************************************

Flock of Birds

************************************************************************
***********************************************************************/


#include <windows.h>

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#include "comaccess.h" 

#include "sensors.h"


// DO NOT MODIFY THESE DECLARATIONS----------------
extern "C" __declspec(dllexport) void QuerySensor(void *);
extern "C" __declspec(dllexport) void InitializeSensor(void *);
extern "C" __declspec(dllexport) void UpdateSensor(void *);
extern "C" __declspec(dllexport) void CommandSensor(void *);
extern "C" __declspec(dllexport) void ResetSensor(void *);
extern "C" __declspec(dllexport) void CloseSensor(void *);

ComAccess  *com;

void QuerySensor(void *sensor)
{
	// This function gets called during the winvrut initialization process.
	// Its only purpose is to set the sensor type (see choices in sensor.h),
	// so that it can be automatically made available to the user according
	// to its type.
	// No initialization or communication should be attempted at this point
	// because the device may never be requested by user (and it might not
	// even be connect!).
	
	strcat(((VRUTSensorObj *)sensor)->version, "Bike_macmaster Driver v0.1");
	((VRUTSensorObj *)sensor)->type = SENSOR_HEADORI | SENSOR_HEADPOS;
}


void InitializeSensor(void *sensor)
{
	if ( ! (com = new ComAccess()) )
	{
		printf("Error: Not enough memory to create ComAccess object!\n");
		return;
	}


	//
	// open and init the communication device with the passed com number
	//
	if ( ! com->Open("com1") )
	{
		printf("Error: Can't open communication device!\n"
		       "%s", com->GetErrorMessage());
		delete com;
		return;
	}

}

void UpdateSensor(void *sensor)
{

	// Update the sensor data fields (see sensor.h)

	unsigned char       buffer[256+1];

	int        read_len,
	           read_result;

	buffer[0] = '\0';

	// make sure not to overload buffer
	read_len = 8; 

	read_result = com->ReadData(buffer, read_len);

	// -1 ? then we got an error and print it
	if ( (read_result < 0)  )
		printf(com->GetErrorMessage());
		
	// set end of received data
	buffer[read_len] = '\0';


	//
	// display results
	//
	//printf("%d bytes read\n%s",read_result, buffer);


		((VRUTSensorObj *)sensor)->data[0] = buffer[0];
		((VRUTSensorObj *)sensor)->data[1] = buffer[1];
		((VRUTSensorObj *)sensor)->data[2] = buffer[2];
		((VRUTSensorObj *)sensor)->data[3] = buffer[3];
		((VRUTSensorObj *)sensor)->data[4] = buffer[4];
		((VRUTSensorObj *)sensor)->data[5] = buffer[5];
		((VRUTSensorObj *)sensor)->data[6] = buffer[6];
	//	((VRUTSensorObj *)sensor)->data[7] = buffer[7];

}

void ResetSensor(void *sensor)
{
}

void CommandSensor(void *sensor)
{
}

void CloseSensor(void *sensor)
{

	// close communication device
	com->Close();

	// destruct the communication device object and free memory 
	delete com;
}





