import viz
viz.go()

#Create quad and place it in front of user
quad = viz.add(viz.TEXQUAD,pos = (0,1.8,3))

#Add main texture
tex1 = viz.add('ball.jpg')

#Add detail texture in repeat mode
tex2 = viz.add('gb_noise.jpg',wrap=viz.REPEAT)

#Apply textures to quad
quad.texture(tex1)
quad.texture(tex2,unit=1)

#Repeat detail texture 20 times
quad.texmat(viz.Transform.scale(20,20,1),unit=1)

#Apply detail shader to quad
quad.apply( viz.addShader( frag = 'detail.frag' ) )

#Apply shader uniforms
quad.apply( viz.addUniformInt( 'BaseTexture', 0 ) )
quad.apply( viz.addUniformInt( 'DetailTexture', 1 ) )